/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.sdk.context;

import com.huawei.fit.sdk.context.GetAllGlobalContext;
import com.huawei.fit.sdk.context.RestoreGlobalContext;
import com.huawei.fit.sdk.context.entity.GlobalContext;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.core.common.util.Convert;
import com.huawei.fitframework.sdk.context.filter.GlobalContextFilter;
import com.huawei.fitframework.serialization.JsonSerializer;
import com.huawei.fitframework.tlv.TlvSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class GlobalContextTlvSerializer
implements TlvSerializer<GlobalContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalContextTlvSerializer.class);
    private static final int GLOBAL_CONTEXT_TAG = 1010;
    private final JsonSerializer jsonSerializer;
    private final GetAllGlobalContext getAllGlobalContext;
    private final RestoreGlobalContext restoreGlobalContext;
    private final List<GlobalContextFilter> globalContextFilters;

    public Map<Integer, byte[]> serialize(GlobalContext data) {
        GlobalContext globalContext = this.getAllGlobalContext.process();
        this.globalContextFilters.forEach(filter -> this.preFilter((GlobalContextFilter)filter, globalContext));
        String allGlobalContextJson = this.jsonSerializer.serialize((Object)globalContext);
        HashMap<Integer, byte[]> result = new HashMap<Integer, byte[]>();
        result.put(1010, Convert.toBytes((String)allGlobalContextJson));
        return result;
    }

    public GlobalContext deserialize(TagLengthValues tagValues) {
        return Optional.of(Convert.toString((byte[])tagValues.getValue(1010))).map(json -> this.jsonSerializer.deserialize(json, GlobalContext.class)).map(GlobalContext.class::cast).map(this::restoreGlobalContext).orElse(null);
    }

    private GlobalContext restoreGlobalContext(GlobalContext globalContext) {
        this.globalContextFilters.forEach(filter -> this.postFilter((GlobalContextFilter)filter, globalContext));
        this.restoreGlobalContext.process(globalContext);
        return globalContext;
    }

    private void preFilter(GlobalContextFilter filter, GlobalContext globalContext) {
        try {
            filter.beforeSend(globalContext);
        }
        catch (Throwable throwable) {
            log.debug("Pre-filter global context failed.", throwable);
            log.error("Pre-filter global context failed: {}", (Object)throwable.getMessage());
        }
    }

    private void postFilter(GlobalContextFilter filter, GlobalContext globalContext) {
        try {
            filter.afterReceive(globalContext);
        }
        catch (Throwable throwable) {
            log.debug("After-filter global context failed.", throwable);
            log.error("After-filter global context failed: {}", (Object)throwable.getMessage());
        }
    }

    @Generated
    public GlobalContextTlvSerializer(JsonSerializer jsonSerializer, GetAllGlobalContext getAllGlobalContext, RestoreGlobalContext restoreGlobalContext, List<GlobalContextFilter> globalContextFilters) {
        this.jsonSerializer = jsonSerializer;
        this.getAllGlobalContext = getAllGlobalContext;
        this.restoreGlobalContext = restoreGlobalContext;
        this.globalContextFilters = globalContextFilters;
    }
}

