/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.sdk.context;

import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ThreadLocalUtils {
    public static Optional<String> get(ThreadLocal<Map<String, String>> context, String key) {
        Validation.notNull(context, (String)"Context is null.", (Object[])new Object[0]);
        if (StringUtils.isBlank((String)key)) {
            return Optional.empty();
        }
        Map<String, String> data = context.get();
        if (MapUtils.isEmpty(data)) {
            return Optional.empty();
        }
        return Optional.ofNullable(data.get(key));
    }

    public static Map<String, String> getAll(ThreadLocal<Map<String, String>> context) {
        Validation.notNull(context, (String)"Context is null.", (Object[])new Object[0]);
        Map<String, String> data = context.get();
        if (data == null) {
            return new HashMap<String, String>();
        }
        return data;
    }

    public static boolean put(ThreadLocal<Map<String, String>> context, String key, String value) {
        Validation.notNull(context, (String)"Context is null.", (Object[])new Object[0]);
        if (StringUtils.isBlank((String)key)) {
            return false;
        }
        if (value == null) {
            return true;
        }
        ((Map)ObjectUtils.getIfNull(context.get(), () -> ThreadLocalUtils.init(context))).put(key, value);
        return true;
    }

    private static Map<String, String> init(ThreadLocal<Map<String, String>> context) {
        HashMap<String, String> map = new HashMap<String, String>();
        context.set(map);
        return map;
    }

    public static boolean remove(ThreadLocal<Map<String, String>> context, String key) {
        Validation.notNull(context, (String)"Context is null.", (Object[])new Object[0]);
        if (StringUtils.isBlank((String)key)) {
            return false;
        }
        Map<String, String> data = context.get();
        if (!MapUtils.isEmpty(data)) {
            data.remove(key);
        }
        if (MapUtils.isEmpty(data)) {
            context.remove();
        }
        return true;
    }

    public static void clear(ThreadLocal<Map<String, String>> context) {
        Validation.notNull(context, (String)"Context is null.", (Object[])new Object[0]);
        context.remove();
    }
}

