/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.sdk.context.filter;

import com.huawei.fit.sdk.context.entity.GlobalContext;
import com.huawei.fit.sdk.context.entity.Pair;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.sdk.context.filter.GlobalContextFilter;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class TtlGlobalContextFilter
implements GlobalContextFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TtlGlobalContextFilter.class);
    private static final int TTL_MIN_TIME = 0;
    private static final String TTL_PREFIX = "fit.pass.ttl.";

    @Override
    public void beforeSend(GlobalContext globalContext) {
        if (globalContext == null || globalContext.getPair() == null) {
            return;
        }
        Set ttlExpiredKeySet = globalContext.getPair().stream().filter(pair -> pair.getKey().startsWith(TTL_PREFIX)).filter(pair -> this.parseValue((Pair)pair) <= 0).map(Pair::getKey).collect(Collectors.toSet());
        globalContext.getPair().removeIf(pair -> this.ttlExpired(ttlExpiredKeySet, pair.getKey()));
    }

    @Override
    public void afterReceive(GlobalContext globalContext) {
        if (globalContext == null || globalContext.getPair() == null) {
            return;
        }
        globalContext.getPair().stream().filter(pair -> pair.getKey().startsWith(TTL_PREFIX)).forEach(this::decreaseTtl);
    }

    private void decreaseTtl(Pair pair) {
        int value = this.parseInt(pair.getValue()) - 1;
        pair.setValue(String.valueOf(value));
    }

    private boolean ttlExpired(Set<String> ttlExpiredKeySet, String key) {
        String ttlKey = key.startsWith(TTL_PREFIX) ? key : TTL_PREFIX + key;
        return ttlExpiredKeySet.contains(ttlKey);
    }

    private int parseValue(Pair pair) {
        return this.parseInt(pair.getValue());
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.error("Convert ttl times failed. Value: {}", (Object)value);
            return 0;
        }
    }
}

