/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.webapp.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.camunda.bpm.spring.boot.starter.webapp.filter.LazyInitRegistration;

public class LazyDelegateFilter<T extends Filter>
implements Filter {
    protected final Class<? extends T> delegateClass;
    protected InitHook<T> initHook;
    protected T delegate;
    protected FilterConfig filterConfig;

    public LazyDelegateFilter(Class<? extends T> delegateClass) {
        this.delegateClass = delegateClass;
        LazyInitRegistration.register(this);
    }

    public void lazyInit() {
        try {
            this.delegate = this.createNewFilterInstance();
            if (this.initHook != null) {
                this.initHook.init(this.delegate);
            }
            this.delegate.init(this.filterConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        LazyInitRegistration.lazyInit(this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter(request, response, chain);
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    public InitHook<T> getInitHook() {
        return this.initHook;
    }

    public void setInitHook(InitHook<T> initHook) {
        this.initHook = initHook;
    }

    public Class<? extends T> getDelegateClass() {
        return this.delegateClass;
    }

    protected T createNewFilterInstance() throws InstantiationException, IllegalAccessException {
        return (T)((Filter)this.delegateClass.newInstance());
    }

    public static interface InitHook<T extends Filter> {
        public void init(T var1);
    }
}

