/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.webapp.filter;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.spring.boot.starter.property.WebappProperty;
import org.camunda.bpm.spring.boot.starter.webapp.filter.ResourceLoaderDependingFilter;
import org.camunda.bpm.webapp.impl.security.filter.SecurityFilter;
import org.camunda.bpm.webapp.impl.security.filter.util.FilterRules;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceLoadingSecurityFilter
extends SecurityFilter
implements ResourceLoaderDependingFilter {
    private ResourceLoader resourceLoader;
    private WebappProperty webappProperty;

    protected void loadFilterRules(FilterConfig filterConfig, String applicationPath) throws ServletException {
        InputStream configFileResource;
        String configFileName = filterConfig.getInitParameter("configFile");
        Resource resource = this.resourceLoader.getResource("classpath:" + this.webappProperty.getWebjarClasspath() + configFileName);
        try {
            configFileResource = resource.getInputStream();
        }
        catch (IOException e1) {
            throw new ServletException("Could not read security filter config file '" + configFileName + "': no such resource in servlet context.");
        }
        try {
            this.filterRules = FilterRules.load((InputStream)configFileResource, (String)applicationPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while parsing '" + configFileName + "'", e);
        }
        finally {
            IoUtil.closeSilently((Closeable)configFileResource);
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public WebappProperty getWebappProperty() {
        return this.webappProperty;
    }

    @Override
    public void setWebappProperty(WebappProperty webappProperty) {
        this.webappProperty = webappProperty;
    }
}

