/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.serialization;

import com.huawei.fitframework.serialization.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public interface CharacterSerializer<T> {
    public void serialize(T var1, Writer var2) throws IOException;

    default public String serialize2String(T value) {
        return CharacterSerializer.serialize2String(this, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> String serialize2String(CharacterSerializer<T> serializer, T value) {
        try (StringWriter writer = new StringWriter();){
            serializer.serialize(value, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new SerializationException("Fail to serialize object with serializer: " + e.getMessage(), e);
        }
    }

    public T deserialize(Reader var1) throws IOException;

    default public T deserialize(String value) {
        return CharacterSerializer.deserialize(this, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(CharacterSerializer<T> serializer, String value) {
        try (StringReader reader = new StringReader(value);){
            T t = serializer.deserialize(reader);
            return t;
        }
        catch (IOException e) {
            throw new SerializationException("Fail to deserialize object from bytes: " + e.getMessage(), e);
        }
    }
}

