/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.serialization.util;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.ByteSerializer;
import com.huawei.fitframework.serialization.util.IllegalVaryingNumberException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class VaryingNumber
extends Number
implements Comparable<VaryingNumber> {
    private static final int BITS_PER_BYTE = 7;
    private static final byte BYTE_DATA_MASK = 127;
    private static final byte BYTE_MB_MASK = (byte)(~Byte.toUnsignedInt((byte)127));
    private final byte[] bytes;

    private VaryingNumber(byte[] bytes) {
        this.bytes = (byte[])Validation.notNull((Object)bytes, (String)"Bytes is null.", (Object[])new Object[0]);
        Validation.greaterThanOrEquals((int)this.bytes.length, (int)1, (String)"Bytes is not enough.", (Object[])new Object[0]);
    }

    public static ByteSerializer<VaryingNumber> serializer() {
        return Serializer.INSTANCE;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public byte byteValue() {
        Validation.isTrue((boolean)this.isBitNumValid(1), (String)"Data truncation for byte. [bytes length={0}]", (Object[])new Object[]{this.bytes.length});
        return (byte)this.parseLong();
    }

    @Override
    public short shortValue() {
        Validation.isTrue((boolean)this.isBitNumValid(2), (String)"Data truncation for short. [bytes length={0}]", (Object[])new Object[]{this.bytes.length});
        return (short)this.parseLong();
    }

    @Override
    public int intValue() {
        Validation.isTrue((boolean)this.isBitNumValid(4), (String)"Data truncation for int. [bytes length={0}]", (Object[])new Object[]{this.bytes.length});
        return (int)this.parseLong();
    }

    @Override
    public long longValue() {
        Validation.isTrue((boolean)this.isBitNumValid(8), (String)"Data truncation for long. [bytes length={0}]", (Object[])new Object[]{this.bytes.length});
        return this.parseLong();
    }

    private long parseLong() {
        long value = 0L;
        for (int index = 0; index < this.bytes.length; ++index) {
            byte item = this.bytes[index];
            value <<= 7;
            value |= (long)(Byte.toUnsignedInt(item) & 0x7F);
        }
        return value;
    }

    @Override
    public float floatValue() {
        Validation.isTrue((boolean)this.isBitNumValid(4), (String)"Data truncation for float. [bytes length={0}]", (Object[])new Object[]{this.bytes.length});
        return this.parseLong();
    }

    @Override
    public double doubleValue() {
        Validation.isTrue((boolean)this.isBitNumValid(8), (String)"Data truncation for double. [bytes length={0}]", (Object[])new Object[]{this.bytes.length});
        return this.parseLong();
    }

    private boolean isBitNumValid(int byteNum) {
        byte firstByte = this.bytes[0];
        int actualValidBitNum = this.calValidBits(firstByte) + (this.bytes.length - 1) * 7;
        return actualValidBitNum <= byteNum * 8;
    }

    private int calValidBits(byte value) {
        int validNum = 0;
        for (int actualByte = value & 0x7F; actualByte != 0; actualByte >>= 1) {
            ++validNum;
        }
        return validNum;
    }

    private static boolean hasMoreBytes(byte value) {
        return !VaryingNumber.noMoreBytes(value);
    }

    private static boolean noMoreBytes(byte value) {
        return (value & BYTE_MB_MASK) == 0;
    }

    private static int measure(int bits) {
        int length = bits / 7;
        if (length % 7 > 0) {
            ++length;
        }
        return length;
    }

    public static VaryingNumber valueOf(byte[] bytes) {
        if (bytes == null || bytes.length < 1) {
            throw new IllegalVaryingNumberException("The bytes of a varying number cannot be null or empty.");
        }
        for (int i = 0; i < bytes.length - 1; ++i) {
            if (!VaryingNumber.noMoreBytes(bytes[i])) continue;
            throw new IllegalVaryingNumberException(StringUtils.format((String)"The bytes of varying number ends at {0} but there are {1} bytes totally.", (Object[])new Object[]{i, bytes.length}));
        }
        if (VaryingNumber.hasMoreBytes(bytes[bytes.length - 1])) {
            throw new IllegalVaryingNumberException("The bytes of varying number is incomplete.");
        }
        return new VaryingNumber(bytes);
    }

    public static VaryingNumber valueOf(byte value) {
        return new VaryingNumber(new byte[]{value});
    }

    public static VaryingNumber valueOf(short value) {
        return new VaryingNumber(VaryingNumber.parse(new Int16ByteIterator(value)));
    }

    public static VaryingNumber valueOf(int value) {
        return new VaryingNumber(VaryingNumber.parse(new Int32ByteIterator(value)));
    }

    public static VaryingNumber valueOf(long value) {
        return new VaryingNumber(VaryingNumber.parse(new Int64ByteIterator(value)));
    }

    private static byte[] parse(ByteIterator iterator) {
        if (!iterator.hasNext()) {
            return new byte[]{0};
        }
        int length = VaryingNumber.measure(iterator.bits());
        byte[] bytesValue = new byte[length];
        int index = bytesValue.length - 1;
        bytesValue[index--] = iterator.next();
        while (iterator.hasNext()) {
            bytesValue[index--] = (byte)(Byte.toUnsignedInt(iterator.next()) | BYTE_MB_MASK);
        }
        int startIndex = Math.min(index + 1, bytesValue.length - 1);
        byte[] actualBytes = new byte[bytesValue.length - startIndex];
        System.arraycopy(bytesValue, startIndex, actualBytes, 0, actualBytes.length);
        return actualBytes;
    }

    @Override
    public int compareTo(VaryingNumber another) {
        int result = Integer.compare(this.bytes.length, another.bytes.length);
        if (result == 0) {
            for (int i = 0; i < this.bytes.length && result == 0; ++i) {
                result = Byte.compare(this.bytes[i], another.bytes[i]);
            }
        }
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VaryingNumber) {
            VaryingNumber another = (VaryingNumber)obj;
            return this.compareTo(another) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.bytes.length << 1);
        for (byte aByte : this.bytes) {
            String text = Integer.toHexString(Byte.toUnsignedInt(aByte));
            if (text.length() == 1) {
                builder.append('0');
            }
            builder.append(text);
        }
        return builder.toString();
    }

    private static class Serializer
    implements ByteSerializer<VaryingNumber> {
        private static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(VaryingNumber num, OutputStream out) throws IOException {
            out.write(num.bytes());
        }

        @Override
        public VaryingNumber deserialize(InputStream in) throws IOException {
            byte[] bytesValue;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int value;
                while ((value = in.read()) >= 0) {
                    out.write(value);
                    if (!VaryingNumber.noMoreBytes((byte)value)) continue;
                }
                bytesValue = out.toByteArray();
            }
            if (bytesValue.length > 0) {
                return VaryingNumber.valueOf(bytesValue);
            }
            return null;
        }
    }

    private static class Int64ByteIterator
    implements ByteIterator {
        private static final int BITS = 64;
        private long value;

        private Int64ByteIterator(long value) {
            this.value = value;
        }

        @Override
        public int bits() {
            return 64;
        }

        @Override
        public boolean hasNext() {
            return this.value != 0L;
        }

        @Override
        public byte next() {
            byte next = (byte)(this.value & 0x7FL);
            this.value >>>= 7;
            return next;
        }
    }

    private static class Int32ByteIterator
    implements ByteIterator {
        private static final int BITS = 32;
        private int value;

        private Int32ByteIterator(int value) {
            this.value = value;
        }

        @Override
        public int bits() {
            return 32;
        }

        @Override
        public boolean hasNext() {
            return this.value != 0;
        }

        @Override
        public byte next() {
            byte next = (byte)(this.value & 0x7F);
            this.value >>>= 7;
            return next;
        }
    }

    private static class Int16ByteIterator
    implements ByteIterator {
        private static final int BITS = 16;
        private short value;

        private Int16ByteIterator(short value) {
            this.value = value;
        }

        @Override
        public int bits() {
            return 16;
        }

        @Override
        public boolean hasNext() {
            return this.value != 0;
        }

        @Override
        public byte next() {
            byte next = (byte)(this.value & 0x7F);
            this.value = (short)(Short.toUnsignedInt(this.value) >>> 7);
            return next;
        }
    }

    private static interface ByteIterator {
        public int bits();

        public boolean hasNext();

        public byte next();
    }
}

