/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.hakuna.system;

import com.huawei.fit.hakuna.system.worker.QueryConfigurations;
import com.huawei.fit.hakuna.system.worker.QueryGenericableInfos;
import com.huawei.fit.hakuna.system.worker.entity.FitableInfo;
import com.huawei.fit.hakuna.system.worker.entity.GenericableConfig;
import com.huawei.fit.hakuna.system.worker.entity.GenericableInfo;
import com.huawei.fit.hakuna.system.worker.entity.QueryConfigurationsFilter;
import com.huawei.fit.hakuna.system.worker.entity.QueryGenericableInfosFilter;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableType;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.hakuna.system.SystemHandler;
import com.huawei.fitframework.hakuna.system.utils.GenericableConfigConvertUtil;
import com.huawei.fitframework.runtime.ApplicationStartupCompletedListener;
import com.huawei.fitframework.runtime.ApplicationStartupCompletedObserver;
import com.huawei.fitframework.runtime.FitRuntimeException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class Worker
implements ApplicationStartupCompletedObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    private static final long ONE_THOUSAND = 1000L;
    private static final long DEFAULT_STARTUP_TIMEOUT = 180000L;
    private final ProxyFactory proxyFactory;
    private final SystemHandler systemHandler;
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1));
    private final long workerStartupTime;
    private final long workerStartupTimeout;
    private volatile boolean applicationStartupCompleted = false;

    public Worker(ProxyFactory proxyFactory, @Fit SystemHandler systemHandler, @Fit ApplicationStartupCompletedListener applicationStartupCompletedListener, @Value(value="${fit.startup.instant}") Long startupTime, @Value(value="${worker.startup-timeout}") String workerStartupTimeout) {
        this.proxyFactory = proxyFactory;
        this.systemHandler = systemHandler;
        this.workerStartupTime = (Long)ObjectUtils.getIfNull((Object)startupTime, System::currentTimeMillis);
        this.workerStartupTimeout = this.getStartupTimeout(workerStartupTimeout);
        applicationStartupCompletedListener.addObserver((ApplicationStartupCompletedObserver)this);
    }

    @PostConstruct
    public void init() {
        if (this.workerStartupTimeout <= 0L) {
            return;
        }
        this.threadPoolExecutor.submit(new StartupStatusCheckTask(this.workerStartupTime, this.workerStartupTimeout));
    }

    @Fitable(generic=QueryGenericableInfos.class, id="4759e4014b234a6baa0f44945a6c1eb4")
    public Map<String, GenericableInfo> queryGenericableInfos(QueryGenericableInfosFilter filter) {
        QueryGenericableInfosFilter actualFilter = (QueryGenericableInfosFilter)ObjectUtils.getIfNull((Object)filter, () -> QueryGenericableInfosFilter.builder().build());
        List genericableIds = this.proxyFactory.listGenericableIds(actualFilter.getPackagePrefix());
        HashMap<String, GenericableInfo> genericableInfos = new HashMap<String, GenericableInfo>();
        for (String genericableId : genericableIds) {
            Optional<String> opType = this.proxyFactory.getConfigurationLoader().load().genericable(genericableId).map(GenericableConfiguration::type).map(GenericableType::code);
            if (StringUtils.isNotBlank((String)actualFilter.getType())) {
                opType = opType.filter(genericableType -> Objects.equals(genericableType, actualFilter.getType()));
            }
            if (!opType.isPresent()) continue;
            List fitableIds = this.proxyFactory.listLocalFitableIds(genericableId);
            genericableInfos.put(genericableId, GenericableInfo.builder().id(genericableId).fitableInfos(fitableIds.stream().map(fitableId -> FitableInfo.builder().id(fitableId).build()).collect(Collectors.toList())).type(opType.get()).build());
        }
        return genericableInfos;
    }

    private long getStartupTimeout(String timeout) {
        if (StringUtils.isBlank((String)timeout)) {
            log.info("No startup timeout configuration, default value is {} ms.", (Object)180000L);
            return 180000L;
        }
        try {
            int specifiedTimoutConfiguration = Integer.parseInt(timeout);
            log.info("Specified startup timeout configuration, its value is {} s.", (Object)specifiedTimoutConfiguration);
            return (long)specifiedTimoutConfiguration * 1000L;
        }
        catch (NumberFormatException e) {
            log.error("Startup timeout cannot convert to int. [timeout={}]", (Object)timeout, (Object)e);
            throw new FitRuntimeException(StringUtils.format((String)"Startup timeout cannot convert to int. [timeout={0}]", (Object[])new Object[]{timeout}));
        }
    }

    @Fitable(generic=QueryConfigurations.class, id="3a9d662f0c004fe1abd1f46ab0502d4e")
    public GenericableConfig queryConfigurations(String genericableId, QueryConfigurationsFilter filter) {
        GenericableConfiguration genericableConfiguration = (GenericableConfiguration)this.proxyFactory.getConfigurationLoader().load().genericable(genericableId).orElseThrow(() -> new FitException(genericableId, "", StringUtils.format((String)"Can not find the config. [genericableId={0}]", (Object[])new Object[]{genericableId})));
        return GenericableConfigConvertUtil.toGenericableConfig(genericableConfiguration, filter);
    }

    public void onApplicationStartupCompleted() {
        this.applicationStartupCompleted = true;
    }

    class StartupStatusCheckTask
    implements Runnable {
        private final long startTimeMillis;
        private final long timeoutMillis;

        StartupStatusCheckTask(long startTimeMillis, long timeoutMillis) {
            this.startTimeMillis = startTimeMillis;
            this.timeoutMillis = timeoutMillis;
        }

        @Override
        public void run() {
            long sleepTime = this.timeoutMillis - (System.currentTimeMillis() - this.startTimeMillis);
            if (sleepTime < 0L) {
                this.doTimeoutOperation();
                return;
            }
            ThreadUtils.sleep((long)sleepTime);
            if (!Worker.this.applicationStartupCompleted) {
                this.doTimeoutOperation();
            }
        }

        private void doTimeoutOperation() {
            log.error("Application startup timeout. [startUpTimeout={}ms]", (Object)this.timeoutMillis);
            Worker.this.systemHandler.exit();
        }
    }
}

