/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.hakuna.system.utils;

import com.huawei.fit.hakuna.system.worker.entity.FitableConfig;
import com.huawei.fit.hakuna.system.worker.entity.GenericableConfig;
import com.huawei.fit.hakuna.system.worker.entity.GenericableParamConfig;
import com.huawei.fit.hakuna.system.worker.entity.QueryConfigurationsFilter;
import com.huawei.fit.hakuna.system.worker.entity.RouteConfig;
import com.huawei.fit.hakuna.system.worker.entity.RuleRouteConfig;
import com.huawei.fit.hakuna.system.worker.entity.TaggerConfig;
import com.huawei.fitframework.broker.conf.FitableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.RouteConfiguration;
import com.huawei.fitframework.broker.conf.RuleRouteConfiguration;
import com.huawei.fitframework.broker.conf.TaggerConfiguration;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GenericableConfigConvertUtil {
    public static GenericableConfig toGenericableConfig(GenericableConfiguration genericableConfiguration, QueryConfigurationsFilter filter) {
        return GenericableConfig.builder().id(genericableConfiguration.id()).name(genericableConfiguration.name()).type(genericableConfiguration.type().code()).route(GenericableConfigConvertUtil.toRouteConfig(genericableConfiguration.route())).tags(new ArrayList(genericableConfiguration.tags())).params(GenericableConfigConvertUtil.toParams(genericableConfiguration.params())).fitables(GenericableConfigConvertUtil.toFitables(genericableConfiguration.fitables(), filter)).build();
    }

    private static RouteConfig toRouteConfig(RouteConfiguration route) {
        if (route == null) {
            return RouteConfig.builder().build();
        }
        return RouteConfig.builder().rule(GenericableConfigConvertUtil.toRule(route.rule())).build();
    }

    private static RuleRouteConfig toRule(RuleRouteConfiguration rule) {
        if (rule == null) {
            return RuleRouteConfig.builder().build();
        }
        String type = rule.policies().stream().map(policy -> Character.toString(policy.code())).collect(Collectors.joining(""));
        return RuleRouteConfig.builder().id(rule.id()).type(type).build();
    }

    private static List<GenericableParamConfig> toParams(Collection<GenericableParamConfiguration> params) {
        return params.stream().map(GenericableConfigConvertUtil::toGenericableParamConfig).collect(Collectors.toList());
    }

    private static GenericableParamConfig toGenericableParamConfig(GenericableParamConfiguration paramConfiguration) {
        if (paramConfiguration == null) {
            return GenericableParamConfig.builder().build();
        }
        return GenericableParamConfig.builder().name(paramConfiguration.name()).index(Integer.valueOf(paramConfiguration.index())).type(paramConfiguration.type()).taggers(GenericableConfigConvertUtil.toTaggers(paramConfiguration.taggers())).build();
    }

    private static List<TaggerConfig> toTaggers(Collection<TaggerConfiguration> taggers) {
        return taggers.stream().map(GenericableConfigConvertUtil::toTaggerConfig).collect(Collectors.toList());
    }

    private static TaggerConfig toTaggerConfig(TaggerConfiguration taggerConfiguration) {
        if (taggerConfiguration == null) {
            return TaggerConfig.builder().build();
        }
        return TaggerConfig.builder().id(taggerConfiguration.id()).tag(taggerConfiguration.tag()).ruleId(taggerConfiguration.rule()).build();
    }

    private static List<FitableConfig> toFitables(Collection<FitableConfiguration> fitables, QueryConfigurationsFilter filter) {
        return fitables.stream().map(GenericableConfigConvertUtil::toFitableConfig).filter(fitableConfig -> GenericableConfigConvertUtil.filterFitable(fitableConfig, filter)).collect(Collectors.toList());
    }

    private static boolean filterFitable(FitableConfig fitableConfig, QueryConfigurationsFilter filter) {
        boolean containsFitableId = CollectionUtils.isEmpty((Collection)filter.getFitableIds()) || filter.getFitableIds().contains(fitableConfig.getId());
        boolean containsAlias = CollectionUtils.isEmpty((Collection)filter.getAliases()) || fitableConfig.getAliases().stream().anyMatch(alias -> filter.getAliases().contains(alias));
        return containsFitableId & containsAlias;
    }

    private static FitableConfig toFitableConfig(FitableConfiguration fitableConfiguration) {
        if (fitableConfiguration == null) {
            return FitableConfig.builder().aliases(Collections.emptyList()).tags(Collections.emptyList()).build();
        }
        ArrayList aliases = (ArrayList)ObjectUtils.mapIfNotNull((Object)fitableConfiguration.aliases(), ArrayList::new);
        aliases = new ArrayList(aliases);
        ArrayList tags = (ArrayList)ObjectUtils.mapIfNotNull((Object)fitableConfiguration.tags(), ArrayList::new);
        tags = new ArrayList(tags);
        return FitableConfig.builder().id(fitableConfiguration.id()).aliases(aliases).tags(tags).degradation(fitableConfiguration.degradationFitable()).build();
    }
}

