/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.base.util;

import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String ERROR_MSG_RESOURCE = "error_code";

    public static String getStringFromErrorMsg(String key) {
        return ResourceUtils.getStringFromBundle(ERROR_MSG_RESOURCE, key);
    }

    public static String getStringFromBundle(String resourceBundle, String key) {
        ResourceBundle resource = ResourceBundle.getBundle(resourceBundle, SystemEnvUtil.getLanguage());
        if (!resource.containsKey(key)) {
            log.warn("resource not exist: {}-{}", (Object)resourceBundle, (Object)key);
            return "";
        }
        return StringUtils.defaultString((String)resource.getString(key));
    }

    public static String getStringFromBundle(String resourceBundle, String key, Object ... args) {
        return StringUtils.defaultString((String)MessageFormat.format(ResourceUtils.getStringFromBundle(resourceBundle, key), args));
    }

    public static String getString(String key) {
        return ResourceUtils.getStringFromBundle(ERROR_MSG_RESOURCE, key);
    }

    public static String getString(String key, Object ... args) {
        return ResourceUtils.getStringFromBundle(ERROR_MSG_RESOURCE, key, args);
    }

    public static ResourceBundle getResourceBundle(String resourceBundle) {
        return ResourceBundle.getBundle(resourceBundle, SystemEnvUtil.getLanguage());
    }

    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

