/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.base.util;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;

public final class ResponseUtil {
    private static final int SUCCESS = 0;
    private static final int FAILED_CODE = 1;

    public static <T> Response<T> failed(String description, String suggestion) {
        return Response.builder().result(ResponseUtil.failedResult(description, suggestion)).build();
    }

    public static boolean isSuccess(Response<?> response) {
        return response.getResult().getCode().equals(0);
    }

    public static <T> Response<T> failed(T data) {
        return Response.builder().result(ResponseUtil.failedResult()).data(data).build();
    }

    public static <T> Response<T> success(T data) {
        Response response = new Response();
        response.setResult(ResponseUtil.successResult());
        response.setData(data);
        return Response.builder().result(ResponseUtil.successResult()).data(data).build();
    }

    public static <T> Response<T> success() {
        Response response = new Response();
        response.setResult(ResponseUtil.successResult());
        return Response.builder().result(ResponseUtil.successResult()).build();
    }

    private static Result failedResult(String description, String suggestion) {
        return Result.builder().code(Integer.valueOf(1)).description(description).suggestion(suggestion).build();
    }

    private static Result failedResult() {
        return ResponseUtil.failedResult("", "");
    }

    private static Result successResult() {
        return Result.builder().code(Integer.valueOf(0)).build();
    }

    private ResponseUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

