/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.base.util;

import com.huawei.yinglong.smartkit.base.util.FilePathUtils;
import com.huawei.yinglong.smartkit.base.util.SecurityUtils;
import java.io.File;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemEnvUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemEnvUtil.class);
    public static final String KEY_SMARTKIT_TOKEN = "authorization";

    public static String getDefaultUserDir() {
        String dir = System.getProperty("user.dir");
        String path = FilePathUtils.getCanonicalPath(new File(dir));
        dir = dir.replaceAll("\\\\", "");
        dir = dir.replaceAll("/", "");
        dir = dir.replaceAll(":", "");
        dir = dir.replaceAll("\\(", "");
        String string = dir = (dir = dir.replaceAll("\\)", "")).contains("..") ? dir : dir.replaceAll("\\.", "");
        if (dir.matches("([^\\w-\\s]+)|(\\s{2,})")) {
            log.error("The tool path {} contains characters other than letters, digits, underscores, brackets, or spaces. Please change a tool path..", (Object)path);
            return "";
        }
        return path;
    }

    public static Locale getLanguage() {
        String language = System.getenv("language");
        if (StringUtils.isNotEmpty((CharSequence)language) && language.startsWith("zh")) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return Locale.ENGLISH;
    }

    public static String createSmartKitToken() {
        return SecurityUtils.generatePassword(32);
    }

    public static boolean saveSmartkitToken(String token) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            System.setProperty(KEY_SMARTKIT_TOKEN, token);
            return true;
        }
        return false;
    }

    public static String getSmartkitToken() {
        return StringUtils.defaultString((String)System.getProperty(KEY_SMARTKIT_TOKEN));
    }

    private SystemEnvUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

