/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheGetAllEvent;
import com.alicp.jetcache.event.CacheGetEvent;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.support.SquashedLogger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(AbstractCache.class);
    private volatile ConcurrentHashMap<Object, LoaderLock> loaderMap;
    protected volatile boolean closed;
    private static final ReentrantLock reentrantLock = new ReentrantLock();

    ConcurrentHashMap<Object, LoaderLock> initOrGetLoaderMap() {
        if (this.loaderMap == null) {
            reentrantLock.lock();
            try {
                if (this.loaderMap == null) {
                    this.loaderMap = new ConcurrentHashMap();
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
        return this.loaderMap;
    }

    protected void logError(String oper, Object key, Throwable e) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("jetcache(").append(this.getClass().getSimpleName()).append(") ").append(oper).append(" error.");
        if (!(key instanceof byte[])) {
            try {
                sb.append(" key=[").append(this.config().getKeyConvertor().apply(key)).append(']');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SquashedLogger.getLogger(logger).error(sb, e);
    }

    public void notify(CacheEvent e) {
        List<CacheMonitor> monitors = this.config().getMonitors();
        for (CacheMonitor m : monitors) {
            m.afterOperation(e);
        }
    }

    @Override
    public final CacheGetResult<V> GET(K key) {
        long t = System.currentTimeMillis();
        CacheGetResult<V> result = key == null ? new CacheGetResult(CacheResultCode.FAIL, "illegal argument", null) : this.do_GET(key);
        result.future().thenRun(() -> {
            CacheGetEvent event = new CacheGetEvent(this, System.currentTimeMillis() - t, key, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheGetResult<V> do_GET(K var1);

    @Override
    public final MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        long t = System.currentTimeMillis();
        MultiGetResult<K, V> result = keys == null ? new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null) : this.do_GET_ALL(keys);
        result.future().thenRun(() -> {
            CacheGetAllEvent event = new CacheGetAllEvent(this, System.currentTimeMillis() - t, keys, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract MultiGetResult<K, V> do_GET_ALL(Set<? extends K> var1);

    @Override
    public final V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull) {
        return AbstractCache.computeIfAbsentImpl(key, loader, cacheNullWhenLoaderReturnNull, 0L, null, this);
    }

    @Override
    public final V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit) {
        return AbstractCache.computeIfAbsentImpl(key, loader, cacheNullWhenLoaderReturnNull, expireAfterWrite, timeUnit, this);
    }

    private static <K, V> boolean needUpdate(V loadedValue, boolean cacheNullWhenLoaderReturnNull, Function<K, V> loader) {
        if (loadedValue == null && !cacheNullWhenLoaderReturnNull) {
            return false;
        }
        return !(loader instanceof CacheLoader) || !((CacheLoader)loader).vetoCacheUpdate();
    }

    static <K, V> V computeIfAbsentImpl(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit, Cache<K, V> cache) {
        Object loadedValue2;
        CacheGetResult<V> r;
        AbstractCache<K, V> abstractCache = CacheUtil.getAbstractCache(cache);
        CacheUtil.ProxyLoader newLoader = CacheUtil.createProxyLoader(cache, loader, abstractCache::notify);
        if (cache instanceof RefreshCache) {
            RefreshCache refreshCache = (RefreshCache)cache;
            r = refreshCache.GET(key);
            refreshCache.addOrUpdateRefreshTask(key, newLoader);
        } else {
            r = cache.GET(key);
        }
        if (r.isSuccess()) {
            return r.getValue();
        }
        Consumer<Object> cacheUpdater = loadedValue -> {
            if (AbstractCache.needUpdate(loadedValue, cacheNullWhenLoaderReturnNull, newLoader)) {
                if (timeUnit != null) {
                    cache.PUT(key, loadedValue, expireAfterWrite, timeUnit).waitForResult();
                } else {
                    cache.PUT(key, loadedValue).waitForResult();
                }
            }
        };
        if (cache.config().isCachePenetrationProtect()) {
            loadedValue2 = AbstractCache.synchronizedLoad(cache.config(), abstractCache, key, newLoader, cacheUpdater);
        } else {
            loadedValue2 = newLoader.apply(key);
            cacheUpdater.accept(loadedValue2);
        }
        return loadedValue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <K, V> V synchronizedLoad(CacheConfig config, AbstractCache<K, V> abstractCache, K key, Function<K, V> newLoader, Consumer<V> cacheUpdater) {
        LoaderLock ll;
        ConcurrentHashMap<Object, LoaderLock> loaderMap = abstractCache.initOrGetLoaderMap();
        Object lockKey = AbstractCache.buildLoaderLockKey(abstractCache, key);
        do {
            boolean[] create = new boolean[1];
            ll = loaderMap.computeIfAbsent(lockKey, (? super K unusedKey) -> {
                create[0] = true;
                LoaderLock loaderLock = new LoaderLock();
                loaderLock.signal = new CountDownLatch(1);
                loaderLock.loaderThread = Thread.currentThread();
                return loaderLock;
            });
            if (create[0] || ll.loaderThread == Thread.currentThread()) {
                try {
                    CacheGetResult<V> getResult = abstractCache.GET(key);
                    if (getResult.isSuccess()) {
                        ll.success = true;
                        ll.value = getResult.getValue();
                        V v = getResult.getValue();
                        return v;
                    }
                    V loadedValue = newLoader.apply(key);
                    ll.success = true;
                    ll.value = loadedValue;
                    cacheUpdater.accept(loadedValue);
                    V v = loadedValue;
                    return v;
                }
                finally {
                    if (create[0]) {
                        ll.signal.countDown();
                        loaderMap.remove(lockKey);
                    }
                }
            }
            try {
                Duration timeout = config.getPenetrationProtectTimeout();
                if (timeout == null) {
                    ll.signal.await();
                } else {
                    boolean ok = ll.signal.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
                    if (!ok) {
                        logger.info("loader wait timeout:" + timeout);
                        return newLoader.apply(key);
                    }
                }
            }
            catch (InterruptedException e) {
                logger.warn("loader wait interrupted");
                return newLoader.apply(key);
            }
        } while (!ll.success);
        return (V)ll.value;
    }

    private static Object buildLoaderLockKey(Cache c, Object key) {
        if (c instanceof AbstractEmbeddedCache) {
            return ((AbstractEmbeddedCache)c).buildKey(key);
        }
        if (c instanceof AbstractExternalCache) {
            byte[] bytes = ((AbstractExternalCache)c).buildKey(key);
            return ByteBuffer.wrap(bytes);
        }
        if (c instanceof MultiLevelCache) {
            c = ((MultiLevelCache)c).caches()[0];
            return AbstractCache.buildLoaderLockKey(c, key);
        }
        if (c instanceof ProxyCache) {
            c = ((ProxyCache)c).getTargetCache();
            return AbstractCache.buildLoaderLockKey(c, key);
        }
        throw new CacheException("impossible");
    }

    @Override
    public final CacheResult PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = key == null ? CacheResult.FAIL_ILLEGAL_ARGUMENT : this.do_PUT(key, value, expireAfterWrite, timeUnit);
        result.future().thenRun(() -> {
            CachePutEvent event = new CachePutEvent(this, System.currentTimeMillis() - t, key, value, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_PUT(K var1, V var2, long var3, TimeUnit var5);

    @Override
    public final CacheResult PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = map == null ? CacheResult.FAIL_ILLEGAL_ARGUMENT : this.do_PUT_ALL(map, expireAfterWrite, timeUnit);
        result.future().thenRun(() -> {
            CachePutAllEvent event = new CachePutAllEvent(this, System.currentTimeMillis() - t, map, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_PUT_ALL(Map<? extends K, ? extends V> var1, long var2, TimeUnit var4);

    @Override
    public final CacheResult REMOVE(K key) {
        long t = System.currentTimeMillis();
        CacheResult result = key == null ? CacheResult.FAIL_ILLEGAL_ARGUMENT : this.do_REMOVE(key);
        result.future().thenRun(() -> {
            CacheRemoveEvent event = new CacheRemoveEvent(this, System.currentTimeMillis() - t, key, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_REMOVE(K var1);

    @Override
    public final CacheResult REMOVE_ALL(Set<? extends K> keys) {
        long t = System.currentTimeMillis();
        CacheResult result = keys == null ? CacheResult.FAIL_ILLEGAL_ARGUMENT : this.do_REMOVE_ALL(keys);
        result.future().thenRun(() -> {
            CacheRemoveAllEvent event = new CacheRemoveAllEvent(this, System.currentTimeMillis() - t, keys, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_REMOVE_ALL(Set<? extends K> var1);

    @Override
    public final CacheResult PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = key == null ? CacheResult.FAIL_ILLEGAL_ARGUMENT : this.do_PUT_IF_ABSENT(key, value, expireAfterWrite, timeUnit);
        result.future().thenRun(() -> {
            CachePutEvent event = new CachePutEvent(this, System.currentTimeMillis() - t, key, value, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_PUT_IF_ABSENT(K var1, V var2, long var3, TimeUnit var5);

    @Override
    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    static class LoaderLock {
        CountDownLatch signal;
        Thread loaderThread;
        volatile boolean success;
        volatile Object value;

        LoaderLock() {
        }
    }
}

