/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.http.entity.support;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.http.entity.Cookie;
import com.huawei.fitframework.http.entity.support.DefaultHttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultHttpRequestBuilder {
    private String method;
    private String requestURI;
    private String queryString;
    private String protocol;
    private String remoteAddr;
    private int remotePort;
    private String remoteHost;
    private String localAddr;
    private String localName;
    private int localPort;
    private String scheme;
    private StringBuilder requestURL;
    private List<Cookie> cookies;
    private Map<String, String> headers;
    private Map<String, List<String>> parameters;
    private String characterEncoding;
    private String languageTag;
    private Set<String> languageTags;
    private boolean secure;

    public DefaultHttpRequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    public DefaultHttpRequestBuilder requestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public DefaultHttpRequestBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public DefaultHttpRequestBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public DefaultHttpRequestBuilder remoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public DefaultHttpRequestBuilder remotePort(int remotePort) {
        this.remotePort = remotePort;
        return this;
    }

    public DefaultHttpRequestBuilder remoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
        return this;
    }

    public DefaultHttpRequestBuilder localAddr(String localAddr) {
        this.localAddr = localAddr;
        return this;
    }

    public DefaultHttpRequestBuilder localName(String localName) {
        this.localName = localName;
        return this;
    }

    public DefaultHttpRequestBuilder localPort(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public DefaultHttpRequestBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public DefaultHttpRequestBuilder requestURL(StringBuilder requestURL) {
        this.requestURL = requestURL;
        return this;
    }

    public DefaultHttpRequestBuilder cookies(List<Cookie> cookies) {
        this.cookies = cookies;
        return this;
    }

    public DefaultHttpRequestBuilder headers(Map<String, String> headers) {
        this.headers = Optional.ofNullable(headers).map(this::toLowerCase).orElseGet(HashMap::new);
        return this;
    }

    private Map<String, String> toLowerCase(Map<String, String> headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(entry -> StringUtils.toLowerCase((String)((String)entry.getKey())), Map.Entry::getValue));
    }

    public DefaultHttpRequestBuilder parameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
        return this;
    }

    public DefaultHttpRequestBuilder characterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        return this;
    }

    public DefaultHttpRequestBuilder languageTag(String languageTag) {
        this.languageTag = languageTag;
        return this;
    }

    public DefaultHttpRequestBuilder languageTags(Set<String> languageTags) {
        this.languageTags = languageTags;
        return this;
    }

    public DefaultHttpRequestBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public DefaultHttpRequest build() {
        return new DefaultHttpRequest(this.method, this.requestURI, this.queryString, this.protocol, this.remoteAddr, this.remotePort, this.remoteHost, this.localAddr, this.localName, this.localPort, this.scheme, this.requestURL, this.cookies, this.headers, this.parameters, this.characterEncoding, this.languageTag, this.languageTags, this.secure);
    }
}

