/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.heartbeat.heartbeat;

import com.huawei.fit.heartbeat.Heartbeat;
import com.huawei.fit.heartbeat.Leave;
import com.huawei.fit.heartbeat.OfflineHeartbeat;
import com.huawei.fit.heartbeat.OnlineHeartbeat;
import com.huawei.fit.heartbeat.entity.BeatInfo;
import com.huawei.fit.registry.entity.Address;
import com.huawei.fit.sdk.system.GetRegistryMatchedAddress;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.runtime.PluginActivator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class HeartbeatClient
implements PluginActivator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeartbeatClient.class);
    private static final String HEARTBEAT_CLIENT = "heartbeat-client";
    private final Leave leave;
    private final Heartbeat heartbeat;
    private final GetRegistryMatchedAddress getRegistryMatchedAddress;
    private final Map<String, BeatStatus> sceneTypeBeatStatusMap = new ConcurrentHashMap<String, BeatStatus>();
    private final ScheduledExecutorService heartbeatScheduleTask;
    private final long terminateTimeout;

    public HeartbeatClient(@Fit Leave leave, @Fit(retry=1) Heartbeat heartbeat, @Fit GetRegistryMatchedAddress getRegistryMatchedAddress, @Value(value="${heartbeat.terminate.timeout}") long terminateTimeout) {
        this.leave = leave;
        this.heartbeat = heartbeat;
        this.getRegistryMatchedAddress = getRegistryMatchedAddress;
        this.terminateTimeout = Validation.greaterThan((long)terminateTimeout, (long)0L, (String)"terminateTimeout should greater than 0 seconds. [terminateTimeout={0}]", (Object[])new Object[]{terminateTimeout});
        this.heartbeatScheduleTask = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName(HEARTBEAT_CLIENT);
            return thread;
        });
    }

    @PostConstruct
    public void init() {
        log.info("Start scheduled task to heart beat. [initDelay=0 second, period=1 second]");
        this.heartbeatScheduleTask.scheduleWithFixedDelay(this::keepAlive, 0L, 1L, TimeUnit.SECONDS);
    }

    @Fitable(generic=OnlineHeartbeat.class, id="e991e18ff184414eb7fe28fc27fad833")
    public boolean onlineHeartbeat(BeatInfo beatInfo) {
        if (this.isBeatInfoInvalid(beatInfo)) {
            log.warn("Fail to online heartbeat.");
            return false;
        }
        BeatStatus beatStatus = this.sceneTypeBeatStatusMap.computeIfAbsent(beatInfo.getSceneType(), key -> new BeatStatus(this.connect(beatInfo)));
        beatStatus.setBeatInfo(beatInfo);
        log.info("Online heartbeat: {}. [sceneType={}]", (Object)beatStatus.isAlive(), (Object)beatInfo.getSceneType());
        return beatStatus.isAlive();
    }

    @Fitable(generic=OfflineHeartbeat.class, id="2d71fa04fb9e4124ade61e8e027d1ee1")
    public boolean offlineHeartbeat(BeatInfo beatInfo) {
        if (this.isBeatInfoInvalid(beatInfo)) {
            log.warn("Fail to offline heartbeat.");
            return false;
        }
        BeatStatus beatStatus = this.sceneTypeBeatStatusMap.remove(beatInfo.getSceneType());
        if (beatStatus == null) {
            log.info("Offline heartbeat successfully: scene has already been removed. [sceneType={}]", (Object)beatInfo.getSceneType());
            return true;
        }
        boolean ret = this.disconnect(beatInfo);
        log.info("Offline heartbeat: {}. [sceneType={}]", (Object)ret, (Object)beatInfo.getSceneType());
        return ret;
    }

    private boolean isBeatInfoInvalid(BeatInfo beatInfo) {
        if (beatInfo == null) {
            log.warn("Beat info is invalid: no beat info.");
            return true;
        }
        if (StringUtils.isBlank((String)beatInfo.getSceneType())) {
            log.warn("Beat info is invalid: no scene type.");
            return true;
        }
        if (beatInfo.getInitDelay() == null || beatInfo.getInitDelay() < 0L) {
            log.info("Incorrect init-delay of BeatInfo occurs when online heartbeat, reset it to 0. [initDelay={}]", (Object)beatInfo.getInitDelay());
            beatInfo.setInitDelay(Long.valueOf(0L));
        }
        if (beatInfo.getInterval() == null || beatInfo.getInterval() <= 0L) {
            log.warn("Beat info is invalid: incorrect interval. [interval={}]", (Object)beatInfo.getInterval());
            return true;
        }
        if (beatInfo.getAliveTime() == null || beatInfo.getAliveTime() <= 0L) {
            log.warn("Beat info is invalid: incorrect alive time. [aliveTime={}]", (Object)beatInfo.getAliveTime());
            return true;
        }
        return false;
    }

    private void keepAlive() {
        this.sceneTypeBeatStatusMap.values().stream().filter(Objects::nonNull).forEach(this::keepAlive);
    }

    private void keepAlive(BeatStatus beatStatus) {
        if (this.connect(beatStatus.getBeatInfo())) {
            beatStatus.setLastAliveTime(System.currentTimeMillis());
            if (!beatStatus.isAlive()) {
                beatStatus.setAlive(true);
            }
        } else if (beatStatus.isAlive() && this.timeout(beatStatus)) {
            beatStatus.setAlive(false);
        }
    }

    private boolean timeout(BeatStatus beatStatus) {
        return beatStatus.getLastAliveTime() + (Long)ObjectUtils.nullIf((Object)beatStatus.getBeatInfo().getAliveTime(), (Object)0L) < System.currentTimeMillis();
    }

    private boolean connect(BeatInfo beatInfo) {
        try {
            log.info("Prepare to connect with heartbeat server. [sceneType={}]", (Object)beatInfo.getSceneType());
            boolean ret = (Boolean)ObjectUtils.nullIf((Object)this.heartbeat.process(Collections.singletonList(beatInfo), this.getAddress()), (Object)false);
            if (ret) {
                log.info("Connect with heartbeat server successfully. [sceneType={}]", (Object)beatInfo.getSceneType());
            } else {
                log.warn("Fail to connect with heartbeat server. [sceneType={}]", (Object)beatInfo.getSceneType());
            }
            return ret;
        }
        catch (Exception e) {
            log.error("Fail to connect with heartbeat server: {}.", (Object)ExceptionUtils.getReason((Throwable)e));
            log.debug("Fail to connect with heartbeat server.", (Throwable)e);
            return false;
        }
    }

    private boolean disconnect(BeatInfo beatInfo) {
        try {
            log.info("Prepare to disconnect with heartbeat server. [sceneType={}]", (Object)beatInfo.getSceneType());
            boolean ret = (Boolean)ObjectUtils.nullIf((Object)this.leave.process(Collections.singletonList(beatInfo), this.getAddress()), (Object)false);
            if (ret) {
                log.info("Disconnect with heartbeat server successfully. [sceneType={}]", (Object)beatInfo.getSceneType());
            } else {
                log.warn("Fail to disconnect with heartbeat server. [sceneType={}]", (Object)beatInfo.getSceneType());
            }
            return ret;
        }
        catch (Exception e) {
            log.error("Fail to disconnect with heartbeat server: {}.", (Object)ExceptionUtils.getReason((Throwable)e));
            log.debug("Fail to disconnect with heartbeat server.", (Throwable)e);
            return false;
        }
    }

    private Address getAddress() {
        return this.getRegistryMatchedAddress.process();
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(this::stopTask);
        try {
            future.get(this.terminateTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Fail to execute stop task from heart client: {}.", (Object)ExceptionUtils.getReason((Throwable)e));
        }
        catch (TimeoutException e) {
            log.warn("Fail to execute stop task from heart client: task was timeout.");
            future.cancel(true);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void stopTask() {
        boolean awaitTermination;
        this.heartbeatScheduleTask.shutdownNow();
        try {
            awaitTermination = this.heartbeatScheduleTask.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            log.warn("Fail to execute stop task from heart client: await termination was interrupted.", (Throwable)e);
            return;
        }
        if (!awaitTermination) {
            log.warn("Fail to execute stop task from heart client: await termination was timeout.");
        }
        log.info("Start to offline heartbeat.");
        this.offlineAllHeartbeats();
        log.info("Success to offline heartbeat.");
    }

    private void offlineAllHeartbeats() {
        this.sceneTypeBeatStatusMap.values().forEach(beatStatus -> this.offlineHeartbeat(beatStatus.getBeatInfo()));
    }

    private static class BeatStatus {
        private BeatInfo beatInfo;
        private boolean alive;
        private long lastAliveTime;

        public BeatStatus(boolean isAlive) {
            this.alive = isAlive;
        }

        @Generated
        public BeatInfo getBeatInfo() {
            return this.beatInfo;
        }

        @Generated
        public boolean isAlive() {
            return this.alive;
        }

        @Generated
        public long getLastAliveTime() {
            return this.lastAliveTime;
        }

        @Generated
        public void setBeatInfo(BeatInfo beatInfo) {
            this.beatInfo = beatInfo;
        }

        @Generated
        public void setAlive(boolean alive) {
            this.alive = alive;
        }

        @Generated
        public void setLastAliveTime(long lastAliveTime) {
            this.lastAliveTime = lastAliveTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BeatStatus)) {
                return false;
            }
            BeatStatus other = (BeatStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAlive() != other.isAlive()) {
                return false;
            }
            if (this.getLastAliveTime() != other.getLastAliveTime()) {
                return false;
            }
            BeatInfo this$beatInfo = this.getBeatInfo();
            BeatInfo other$beatInfo = other.getBeatInfo();
            return !(this$beatInfo == null ? other$beatInfo != null : !this$beatInfo.equals(other$beatInfo));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BeatStatus;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAlive() ? 79 : 97);
            long $lastAliveTime = this.getLastAliveTime();
            result = result * 59 + (int)($lastAliveTime >>> 32 ^ $lastAliveTime);
            BeatInfo $beatInfo = this.getBeatInfo();
            result = result * 59 + ($beatInfo == null ? 43 : $beatInfo.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HeartbeatClient.BeatStatus(beatInfo=" + this.getBeatInfo() + ", alive=" + this.isAlive() + ", lastAliveTime=" + this.getLastAliveTime() + ")";
        }
    }
}

