/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.installation.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.installation.entity.SystemInstallationActiveResult;
import com.huawei.yinglong.distributed.installation.entity.SystemInstallationParam;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ExportWithScene;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryTaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import com.huawei.yinglong.river.system.installationn.storage.distribution.SystemInstall;
import com.huawei.yinglong.river.system.storage.distribution.entity.SystemInstallationParams;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class SystemInstallationTask {
    private static final Logger log = LoggerFactory.getLogger(SystemInstallationTask.class);
    private static final List<String> SUBTASK_IDS = Collections.singletonList("system_installation");
    private String workerId;
    @Fit(alias="systemInstall\u7684\u5b9e\u73b0")
    private SystemInstall systemInstall;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryTaskDetail;
    @Fit(alias="queryTaskStatistics\u7684\u5b9e\u73b0")
    private QueryTaskStatistics queryTaskStatistics;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private ExportWithScene exportWithScene;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public SystemInstallationTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startOsInstallation", lockDuration=1000L)
    @Bean
    public ExternalTaskHandler startOsInstallation() {
        log.info("Start System Installation");
        return (externalTask, externalTaskService) -> {
            try {
                String executionId = externalTask.getExecutionId();
                SystemInstallationParam params = this.getSystemInstallationParam(executionId, externalTask);
                Response<String> installResponse = this.systemInstall.process(this.buildOsInstallParam(params));
                SystemInstallationActiveResult activeResult = new SystemInstallationActiveResult();
                this.updateOsInstallStatus(externalTask, externalTaskService, executionId, installResponse, activeResult);
            }
            catch (FitException e) {
                log.error("Failed to start the system installation.", e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private SystemInstallationParam getSystemInstallationParam(String executionId, ExternalTask externalTask) {
        SystemInstallationParam params = this.bpmContextService.getContext(executionId, SystemInstallationParam.class);
        params.setTaskId(String.join((CharSequence)"_", externalTask.getProcessInstanceId(), "default"));
        return params;
    }

    private void updateOsInstallStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, String executionId, Response<String> response, SystemInstallationActiveResult activeResult) {
        if (!ResponseUtil.isSuccess(response)) {
            activeResult.setStatus(ResultStatus.FAILED);
            this.bpmContextService.updateActivityResult(executionId, activeResult);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
        activeResult.setStatus(ResultStatus.SUCCESS);
        this.bpmContextService.setProgress(executionId, 100);
        this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
    }

    private SystemInstallationParams buildOsInstallParam(SystemInstallationParam params) {
        return SystemInstallationParams.builder().isoX86Path(params.getIsoX86Path()).isoArmPath(params.getIsoArmPath()).taskId(params.getTaskId()).cpuArchitecture(params.getCpuArchitecture()).timezone(params.getTimezone()).devIds(params.getDevIds()).subTaskIds(SUBTASK_IDS).workPath(params.getWorkPath()).build();
    }

    @ExternalTaskSubscription(value="queryOsInstallationProgress", lockDuration=1000L)
    @Bean
    public ExternalTaskHandler queryOsInstallationProgress() {
        log.info("Querying the installation progress");
        return (externalTask, externalTaskService) -> {
            try {
                String executionId = externalTask.getExecutionId();
                SystemInstallationParam param = this.getSystemInstallationParam(executionId, externalTask);
                TaskStatistics statistics = this.queryTaskStatistics.process(param.getTaskId(), String.join((CharSequence)",", SUBTASK_IDS)).getData();
                MultiDeployTaskDetail details = this.queryTaskDetail.process(this.buildQueryParams(param, SUBTASK_IDS)).getData();
                SystemInstallationTask.resetDetails(details);
                SystemInstallationActiveResult result = this.buildSystemInstallationInitResult(statistics, param, details);
                this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), result);
                this.generateReportWhenFinish(executionId, param.getTaskId(), result);
                this.updateActiveStatus(externalTask, externalTaskService, result);
            }
            catch (FitException e) {
                log.error("Failed to query the system installation progress. An unknown exception occurred.", e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private void generateReportWhenFinish(String executionId, String taskId, SystemInstallationActiveResult result) {
        if (!result.getStatus().isFinished()) {
            return;
        }
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        Response<String> exportRes = this.exportWithScene.process(taskId.split("_")[0], processConfig.getReportDir(), "os_installation");
        log.info("export version check report result: {}", (Object)exportRes);
    }

    private QueryTaskDetailParam buildQueryParams(SystemInstallationParam param, List<String> subTaskIds) {
        return QueryTaskDetailParam.builder().taskId(param.getTaskId()).subTaskIds(subTaskIds).build();
    }

    private SystemInstallationActiveResult buildSystemInstallationInitResult(TaskStatistics statistics, SystemInstallationParam param, MultiDeployTaskDetail details) {
        return ((SystemInstallationActiveResult.SystemInstallationActiveResultBuilder)((SystemInstallationActiveResult.SystemInstallationActiveResultBuilder)((SystemInstallationActiveResult.SystemInstallationActiveResultBuilder)SystemInstallationActiveResult.builder().status(this.getInstallTaskStatus(statistics, param))).overviews(details.getDeployTaskDetails())).taskStatistics(statistics)).build();
    }

    private ResultStatus getInstallTaskStatus(TaskStatistics statistics, SystemInstallationParam param) {
        int totalNum = param.getDevIds().size();
        int finishedNum = statistics.getSuccessNum() + statistics.getFailedNum();
        if (finishedNum < totalNum) {
            return ResultStatus.RUNNING;
        }
        if (statistics.getSuccessNum() == totalNum) {
            return ResultStatus.SUCCESS;
        }
        if (statistics.getFailedNum() == totalNum) {
            return ResultStatus.FAILED;
        }
        return ResultStatus.PART_SUCCESS;
    }

    private static void resetDetails(MultiDeployTaskDetail details) {
        if (details.getDeployTaskDetails() == null) {
            return;
        }
        details.getDeployTaskDetails().forEach(deployTaskDetailVo -> deployTaskDetailVo.setStepTaskDetails(Collections.emptyList()));
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, SystemInstallationActiveResult result) {
        ResultStatus status = result.getStatus();
        if (!status.isFinished()) {
            return;
        }
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }
}

