/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug;

import com.huawei.fit.sdk.context.ClearGlobalContext;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.debug.Command;
import com.huawei.fitframework.debug.factory.DebugCmdFactory;
import com.huawei.fitframework.debug.service.CmdIoService;
import com.huawei.fitframework.runtime.FitDebugger;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultDebugger
implements FitDebugger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDebugger.class);
    private static final String LOG_DIR = Paths.get(System.getProperty("user.dir"), "logs", "worker").toString();
    private final CmdIoService cmdIOService;
    private final DebugCmdFactory debugCmdFactory;
    private final ClearGlobalContext clearGlobalContext;
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1));

    public DefaultDebugger(@Fit DebugCmdFactory debugCmdFactory, @Fit CmdIoService cmdIOService, ClearGlobalContext clearGlobalContext) {
        this.cmdIOService = cmdIOService;
        this.debugCmdFactory = debugCmdFactory;
        this.clearGlobalContext = clearGlobalContext;
    }

    public void start() {
        this.threadPoolExecutor.submit(new CommandHandler(this.cmdIOService, this.debugCmdFactory, this.clearGlobalContext));
    }

    private static class CommandHandler
    implements Runnable {
        private final CmdIoService cmdIOService;
        private final DebugCmdFactory debugCmdFactory;
        private final ClearGlobalContext clearGlobalContext;

        @Override
        public void run() {
            this.cmdIOService.printStartupMessage();
            while (true) {
                Optional<String> command = this.cmdIOService.readCommand();
                command.ifPresent(this::doCommand);
            }
        }

        private void doCommand(String command) {
            try {
                Command debugCmd = this.debugCmdFactory.get(command);
                this.cmdIOService.println(debugCmd.execute(command));
                this.clearGlobalContext.process();
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getReason((Throwable)e));
                log.debug("Exception stack trace.", (Throwable)e);
                log.debug("Exception cause stack trace.", e.getCause());
                this.cmdIOService.println(ExceptionUtils.getReason((Throwable)e));
                this.cmdIOService.println("For more detail message, check logs in directory: " + LOG_DIR);
            }
        }

        @Generated
        public CommandHandler(CmdIoService cmdIOService, DebugCmdFactory debugCmdFactory, ClearGlobalContext clearGlobalContext) {
            this.cmdIOService = cmdIOService;
            this.debugCmdFactory = debugCmdFactory;
            this.clearGlobalContext = clearGlobalContext;
        }
    }
}

