/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.converter.impl;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.debug.converter.InvokeCmdConverter;
import com.huawei.fitframework.debug.entity.InvokeCmd;
import com.huawei.fitframework.debug.service.ProxyService;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@Fitable
public class GenericableAliasCmdConverter
implements InvokeCmdConverter {
    private static final int REFERENCE_GROUP_INDEX = 1;
    private static final int PARAM_GROUP_INDEX = 2;
    private static final int ALIAS_GROUP_INDEX = 4;
    private final ProxyService proxyService;

    @Override
    public Optional<InvokeCmd.Invoke> convert(String command) {
        Matcher matcher = this.getPattern().matcher(command);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String params = matcher.group(2);
        String alias = matcher.group(4);
        String fuzzyGeneric = matcher.group(1);
        Object object = this.proxyService.requireByFuzzyInput(fuzzyGeneric, alias);
        return Optional.of(new InvokeCmd.Invoke(object, params));
    }

    private Pattern getPattern() {
        return InvokeCmd.METHOD_INVOKE_ALIAS_PATTERN;
    }

    @Generated
    public GenericableAliasCmdConverter(ProxyService proxyService) {
        this.proxyService = proxyService;
    }
}

