/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.entity;

import com.huawei.fitframework.debug.Command;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public abstract class CmdBase
implements Command {
    private static final Pattern HELP_PATTERN = Pattern.compile("(.*) (-|--)(help|h)");
    private final List<String> nameList;
    private final String summary;
    private final String description;

    @Override
    public final Object execute(String command) {
        Matcher matcher = HELP_PATTERN.matcher(command);
        if (matcher.matches()) {
            return this.getDescription();
        }
        return this.doCommand(command);
    }

    @Override
    public boolean match(String stringCmd) {
        return this.getPatternList().stream().anyMatch(pattern -> pattern.matcher(stringCmd).matches());
    }

    abstract List<Pattern> getPatternList();

    abstract Object doCommand(String var1);

    @Override
    @Generated
    public List<String> getNameList() {
        return this.nameList;
    }

    @Override
    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public CmdBase(List<String> nameList, String summary, String description) {
        this.nameList = nameList;
        this.summary = summary;
        this.description = description;
    }
}

