/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.entity;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.debug.Command;
import com.huawei.fitframework.debug.entity.CmdBase;
import com.huawei.fitframework.debug.factory.DebugCmdFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

@Fitable
public class HelpCmd
extends CmdBase {
    private static final Pattern MAN_PATTERN = Pattern.compile("man (.*)");
    private static final Pattern HELP_PATTERN = Pattern.compile("help|h");
    private static final List<String> NAME_LIST = Arrays.asList("help", "h", "man");
    private static final String SUMMARY = "Show all fit debug command";
    private static final String DESCRIPTION = "help: Show all fit debug command" + System.lineSeparator() + "help --$param: to show specified command";
    private final DebugCmdFactory debugCmdFactory;

    public HelpCmd(@Fit DebugCmdFactory debugCmdFactory) {
        super(NAME_LIST, SUMMARY, DESCRIPTION);
        this.debugCmdFactory = debugCmdFactory;
    }

    @Override
    public Object doCommand(String command) {
        Matcher matcher = MAN_PATTERN.matcher(command);
        if (matcher.matches()) {
            return this.debugCmdFactory.get(matcher.group(1)).getDescription();
        }
        return this.debugCmdFactory.list().stream().map(HelpVo::getHelpVo).map(HelpVo::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public List<Pattern> getPatternList() {
        return Arrays.asList(MAN_PATTERN, HELP_PATTERN);
    }

    private static class HelpVo {
        private static final String NAME_COLUMN_FORMATTER = "%1$-15s";
        List<String> nameList;
        String summary;
        String description;

        public String toString() {
            String names = StringUtils.join((char)',', this.getNameList());
            return String.format(Locale.ROOT, NAME_COLUMN_FORMATTER, names) + this.getSummary();
        }

        public static HelpVo getHelpVo(Command command) {
            return new HelpVo(command.getNameList(), command.getSummary(), command.getDescription());
        }

        @Generated
        public List<String> getNameList() {
            return this.nameList;
        }

        @Generated
        public String getSummary() {
            return this.summary;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public HelpVo(List<String> nameList, String summary, String description) {
            this.nameList = nameList;
            this.summary = summary;
            this.description = description;
        }
    }
}

