/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.entity;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.debug.converter.InvokeCmdConverter;
import com.huawei.fitframework.debug.converter.impl.InvokeCmdUtil;
import com.huawei.fitframework.debug.entity.CmdBase;
import com.huawei.fitframework.debug.exception.FitDebugException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class InvokeCmd
extends CmdBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InvokeCmd.class);
    public static final Pattern METHOD_INVOKE_PATTERN = Pattern.compile("(.*)\\((.*)\\)");
    public static final Pattern METHOD_INVOKE_ALIAS_PATTERN = Pattern.compile("(.*)\\((.*)\\) -(alias|a) (.*)");
    private static final Pattern INVOKE_PATTERN = Pattern.compile("invoke .*");
    private static final List<String> NAME_LIST = Collections.singletonList("invoke");
    private static final String SUMMARY = "Invoke the genericable by command";
    private static final List<String> DESCRIPTION_LIST = new ArrayList<String>();
    private final BrokerClient brokerClient;

    public InvokeCmd(@Fit BrokerClient brokerClient) {
        super(NAME_LIST, SUMMARY, String.join((CharSequence)System.lineSeparator(), DESCRIPTION_LIST));
        this.brokerClient = brokerClient;
    }

    @Override
    public Object doCommand(String command) {
        Invoke invoke = this.brokerClient.list(InvokeCmdConverter.class).values().stream().map(InvokeCmdConverter.class::cast).map(converter -> converter.convert(command)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> FitDebugException.PARAM_CONVERT_ERROR);
        return invoke.execute();
    }

    @Override
    public List<Pattern> getPatternList() {
        return Arrays.asList(INVOKE_PATTERN, METHOD_INVOKE_PATTERN, METHOD_INVOKE_ALIAS_PATTERN);
    }

    static {
        DESCRIPTION_LIST.add("\u901a\u8fc7Genericable\u63a5\u53e3\u5185\u5b9a\u4e49\u7684\u51fd\u6570\u540d\u548c\u53c2\u6570\u53d1\u8d77\u8c03\u7528\u3002\u5f53\u65e0\u53c2\u6570\u65f6\u65e0\u9700\u8f93\u5165\uff0c\u591a\u4e2a\u53c2\u6570\u65f6\u7528\u9017\u53f7\u5206\u9694\u3002\u4e3e\u4f8b\uff1a");
        DESCRIPTION_LIST.add("sayHelloWorld()");
        DESCRIPTION_LIST.add("sayHi(Tom)");
        DESCRIPTION_LIST.add("sayHi(Tom and Bob)");
        DESCRIPTION_LIST.add("gcd(9, 3)");
        DESCRIPTION_LIST.add("gcd(10086, 6)");
    }

    public static class Invoke {
        private final Object object;
        private final String userInputParams;

        public Invoke(Object object, String userInputParams) {
            this.object = object;
            this.userInputParams = userInputParams;
        }

        public Object execute() {
            Method processMethod = Arrays.stream(ReflectionUtils.getDeclaredMethods(this.object.getClass())).filter(method -> method.getName().equals("process")).findFirst().orElseThrow(() -> new FitDebugException("not found process method"));
            return ReflectionUtils.invoke((Object)this.object, (Method)processMethod, (Object[])this.getActualParams(processMethod.getParameters(), this.userInputParams));
        }

        private Object[] getActualParams(Parameter[] parameters, String userInputParams) {
            List inputParamsList = Arrays.stream(userInputParams.split(",")).map(String::trim).collect(Collectors.toList());
            return InvokeCmdUtil.parseByParameters(Arrays.asList((Object[])parameters.clone()), inputParamsList::get, (stringValue, clazz) -> stringValue);
        }

        @Generated
        public Object getObject() {
            return this.object;
        }
    }
}

