/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.service.impl;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.debug.exception.FitDebugException;
import com.huawei.fitframework.debug.service.BundleService;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginManager;
import java.util.Objects;
import lombok.Generated;

@Fitable
public class BundleServiceImpl
implements BundleService {
    private final PluginManager pluginManager;

    @Override
    public BundleIdentity requireByFitId(String fitId) {
        return this.requirePlugin(fitId).getLocalFitableIdentities().stream().filter(each -> Objects.equals(each.getFitId(), fitId)).findAny().orElseThrow(() -> FitDebugException.NO_FITABLE_FOUND);
    }

    private Plugin requirePlugin(String fitId) {
        return this.pluginManager.list().stream().filter(each -> this.pluginMatched((Plugin)each, fitId)).findAny().orElseThrow(() -> FitDebugException.NO_FITABLE_FOUND);
    }

    private boolean pluginMatched(Plugin plugin, String fitId) {
        return plugin.getLocalFitableIdentities().stream().map(BundleIdentity::getFitId).anyMatch(each -> Objects.equals(each, fitId));
    }

    @Generated
    public BundleServiceImpl(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }
}

