/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.service.impl;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Order;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.fitframework.debug.service.BannerService;
import com.huawei.fitframework.debug.service.CmdIoService;
import com.huawei.fitframework.runtime.ApplicationStartedObserver;
import com.huawei.fitframework.runtime.ApplicationStartupCompletedListener;
import com.huawei.fitframework.runtime.ApplicationStartupCompletedObserver;
import com.huawei.fitframework.runtime.PluginBrief;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Order(value=-700)
public class CmdIoServiceImpl
implements CmdIoService,
ApplicationStartupCompletedObserver,
ApplicationStartedObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CmdIoServiceImpl.class);
    private static final String DEBUG_PROMPT_FORMATTER = "[fit@{0}]$ ";
    private static final Pattern ESCAPE_CHAR_START_PATTERN = Pattern.compile("^\\[[A-Z]");
    private static final Pattern ESCAPE_CHAR_PATTERN = Pattern.compile("\u001b\\[[A-Z0-9][~]?");
    private static final String ESCAPE_CHAR_PROMPT = "Escape chars detected, remove those chars before execution: {0}";
    private static final String START_SUCCESS = "Start success";
    private static final String REGISTRY_SERVICES_MSG = "System is registering services. Please wait a moment...";
    private static final String DEBUG_PORT_FORMATTER = "Debug port: {0}";
    private static final String DEBUG_PORT_KEY = "debug.port";
    private static final String ENVIRONMENT_FORMATTER = "Current environment: {0}";
    private static final String ENVIRONMENT_KEY = "worker.environment";
    private final String prompt;
    private final BannerService bannerService;
    private final Config config;
    private final BrokerClient brokerClient;
    private volatile boolean applicationStartupCompleted = false;

    public CmdIoServiceImpl(@Fit BannerService bannerService, @Fit Config config, @Fit BrokerClient brokerClient, @Value(value="${server.id}") String workerId) {
        this.prompt = StringUtils.format((String)DEBUG_PROMPT_FORMATTER, (Object[])new Object[]{workerId});
        this.bannerService = bannerService;
        this.config = config;
        this.brokerClient = brokerClient;
    }

    @Override
    public Optional<String> readCommand() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            this.print(this.prompt);
            String command = this.filterEscapeChars(reader.readLine().trim());
            return StringUtils.isNotBlank((String)command) ? Optional.of(command) : Optional.empty();
        }
        catch (IOException e) {
            log.error(e.getClass().getName(), (Throwable)e);
            this.println("Read command io error");
            return Optional.empty();
        }
    }

    private String filterEscapeChars(String rawCommand) {
        if (!ESCAPE_CHAR_PATTERN.matcher(rawCommand).find() && !ESCAPE_CHAR_START_PATTERN.matcher(rawCommand).find()) {
            return rawCommand;
        }
        String command = rawCommand.replaceAll(ESCAPE_CHAR_START_PATTERN.pattern(), "").replaceAll(ESCAPE_CHAR_PATTERN.pattern(), "");
        this.println(StringUtils.format((String)ESCAPE_CHAR_PROMPT, (Object[])new Object[]{command}));
        return command;
    }

    @Override
    public void printStartupMessage() {
        this.println(REGISTRY_SERVICES_MSG);
        while (!this.applicationStartupCompleted) {
            ThreadUtils.sleep((long)200L);
        }
        this.println(this.bannerService.loadBanner());
        this.println(START_SUCCESS);
        this.printConfigParam(DEBUG_PORT_KEY, DEBUG_PORT_FORMATTER);
        this.printConfigParam(ENVIRONMENT_KEY, ENVIRONMENT_FORMATTER);
    }

    private void printConfigParam(String configKey, String formatter) {
        String configValue = (String)ObjectUtils.cast((Object)this.config.get((Object)this, configKey));
        if (StringUtils.isNotBlank((String)configValue)) {
            this.println(StringUtils.format((String)formatter, (Object[])new Object[]{configValue}));
        }
    }

    @Override
    public void print(Object message) {
        System.out.print(message);
    }

    @Override
    public void println(Object message) {
        System.out.println(message);
    }

    public void onApplicationStartupCompleted() {
        this.applicationStartupCompleted = true;
    }

    public void onApplicationStarted(List<PluginBrief> plugins) {
        ((ApplicationStartupCompletedListener)this.brokerClient.getProxyByAlias(ApplicationStartupCompletedListener.class, "default")).addObserver((ApplicationStartupCompletedObserver)this);
    }
}

