/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.debug.service.impl;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.debug.exception.FitDebugException;
import com.huawei.fitframework.debug.service.ProxyService;
import lombok.Generated;

@Fitable
public class ProxyServiceImpl
implements ProxyService {
    private final ProxyFactory proxyFactory;

    @Override
    public Object requireByFuzzyInput(String fuzzyGeneric) {
        return this.proxyFactory.listGenericableClasses().stream().filter(clazz -> this.match((Class<?>)clazz, fuzzyGeneric)).findAny().map(clazz -> this.proxyFactory.getBrokerClient().getProxyByDefault(clazz)).orElseThrow(() -> FitDebugException.NO_GENERIC_FOUND);
    }

    @Override
    public Object requireByFuzzyInput(String fuzzyGeneric, String alias) {
        return this.proxyFactory.listGenericableClasses().stream().filter(clazz -> this.match((Class<?>)clazz, fuzzyGeneric)).findAny().map(clazz -> this.proxyFactory.getBrokerClient().getProxyByAlias(clazz, alias)).orElseThrow(() -> FitDebugException.NO_GENERIC_FOUND);
    }

    private boolean match(Class<?> clazz, String fuzzyInput) {
        return StringUtils.equalsIgnoreCase((String)clazz.getSimpleName(), (String)fuzzyInput) || StringUtils.equalsIgnoreCase((String)clazz.getName(), (String)fuzzyInput);
    }

    @Generated
    public ProxyServiceImpl(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }
}

