/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy;

import com.huawei.fitframework.annotation.Genericable;
import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ProxyFactory {
    public BrokerClient getBrokerClient();

    public BrokerClient getCachedBrokerClient();

    public ConfigurationLoader getConfigurationLoader();

    public Optional<ProxyRepository> getLocalProxyRepository(String var1);

    public List<ProxyRepository> getLocalProxyRepositories();

    default public List<String> listLocalFitableIds(String genericableId) {
        if (genericableId == null || genericableId.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getLocalProxyRepositories().stream().flatMap(repo -> repo.getFitableIdentities().stream()).filter(identity -> identity.getGenericId().equalsIgnoreCase(genericableId)).map(BundleIdentity::getFitId).collect(Collectors.toList());
    }

    public void registerGenericable(Class<?> var1);

    public Class<?> getGenericableClass(String var1);

    public boolean contains(String var1);

    public List<Class<?>> listGenericableClasses();

    default public List<String> listGenericableIds() {
        return this.listGenericableClasses().stream().filter(Objects::nonNull).map(clazz -> clazz.getAnnotation(Genericable.class)).filter(Objects::nonNull).map(Genericable::value).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    default public List<String> listGenericableIds(String packagePrefix) {
        if (StringUtils.isBlank((String)packagePrefix)) {
            return this.listGenericableIds();
        }
        return this.listGenericableClasses().stream().filter(Objects::nonNull).filter(clazz -> clazz.getName().startsWith(packagePrefix)).map(clazz -> clazz.getAnnotation(Genericable.class)).filter(Objects::nonNull).map(Genericable::value).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public Proxy getRemoteProxy(String var1, String var2, Target var3, InvokeContext var4);

    public Proxy getRemoteGenericProxy(String var1, String var2, Target var3, InvokeContext var4);

    public Proxy getLocalProxy(String var1, String var2);

    public Proxy getLocalProxy(Class<?> var1, String var2);
}

