/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf;

import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.broker.conf.support.EmbeddedResourceBrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.support.FileBrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.support.FrameworkBrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.support.GenericableBrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.support.JarResourceBrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.support.PluginBrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.support.ValuesBrokerConfigurationConfigurator;
import com.huawei.fitframework.runtime.SystemDirectories;
import java.io.File;
import java.util.Map;

@FunctionalInterface
public interface BrokerConfigurationConfigurator {
    public void configure(ConfigurableBrokerConfiguration var1, ConfigureMode var2);

    public static BrokerConfigurationConfigurator combine(BrokerConfigurationConfigurator first, BrokerConfigurationConfigurator second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return (configuration, mode) -> {
            first.configure(configuration, mode);
            second.configure(configuration, mode);
        };
    }

    public static BrokerConfigurationConfigurator embedded(ClassLoader loader, String resourceKey, ConfigurationReader reader) {
        return new EmbeddedResourceBrokerConfigurationConfigurator(loader, resourceKey, reader);
    }

    public static BrokerConfigurationConfigurator jar(File jar, String resourceKey, ConfigurationReader reader) {
        return new JarResourceBrokerConfigurationConfigurator(jar, resourceKey, reader);
    }

    public static BrokerConfigurationConfigurator file(File file, ConfigurationReader reader) {
        return new FileBrokerConfigurationConfigurator(file, reader);
    }

    public static BrokerConfigurationConfigurator plugin(SystemDirectories.Plugin plugin) {
        return new PluginBrokerConfigurationConfigurator(plugin);
    }

    public static BrokerConfigurationConfigurator framework(SystemDirectories.Framework framework) {
        return new FrameworkBrokerConfigurationConfigurator(framework);
    }

    public static BrokerConfigurationConfigurator values(Map<String, Object> values) {
        return new ValuesBrokerConfigurationConfigurator(values);
    }

    public static BrokerConfigurationConfigurator genericable(String genericableId, Map<String, Object> values) {
        return new GenericableBrokerConfigurationConfigurator(genericableId, values);
    }
}

