/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurableGenericableConfiguration;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultConfigurableBrokerConfiguration
implements ConfigurableBrokerConfiguration {
    private final Map<String, ConfigurableGenericableConfiguration> genericables = new ConcurrentHashMap<String, ConfigurableGenericableConfiguration>();

    @Override
    public Collection<GenericableConfiguration> genericables() {
        return this.genericables.values().stream().map(ConfigurableGenericableConfiguration.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<GenericableConfiguration> genericable(String genericableId) {
        return StringUtils.isBlank((String)genericableId) ? Optional.empty() : Optional.ofNullable(this.genericables.get(genericableId));
    }

    @Override
    public ConfigurableGenericableConfiguration getOrCreateGenericable(String genericableId) {
        return this.genericables.computeIfAbsent(Validation.notBlank((String)genericableId, (String)"The id of a genericable cannot be blank", (Object[])new Object[0]), key -> new DefaultConfigurableGenericableConfiguration(this, (String)key));
    }

    @Override
    public void removeGenericable(String genericableId) {
        if (StringUtils.isNotBlank((String)genericableId)) {
            this.genericables.remove(genericableId);
        }
    }
}

