/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.ConfigurableFitableConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableConfiguration;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Collections;

public class DefaultConfigurableFitableConfiguration
implements ConfigurableFitableConfiguration {
    private final ConfigurableGenericableConfiguration parent;
    private final String id;
    private volatile Collection<String> aliases;
    private volatile Collection<String> tags;
    private volatile String degradationFitable;
    private final Object lock = new byte[0];

    public DefaultConfigurableFitableConfiguration(ConfigurableGenericableConfiguration parent, String id) {
        this.parent = (ConfigurableGenericableConfiguration)Validation.notNull((Object)parent, (String)"The parent of fitable configuration cannot be null.", (Object[])new Object[0]);
        this.id = Validation.notBlank((String)id, (String)"The id of fitable cannot be blank.", (Object[])new Object[0]);
        this.aliases = Collections.emptySet();
        this.tags = Collections.emptySet();
        this.degradationFitable = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFitableConfiguration aliases(Collection<String> aliases) {
        Object object = this.lock;
        synchronized (object) {
            this.aliases = (Collection)ObjectUtils.nullIf(aliases, Collections.emptySet());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFitableConfiguration tags(Collection<String> tags) {
        Object object = this.lock;
        synchronized (object) {
            this.tags = (Collection)ObjectUtils.nullIf(tags, Collections.emptySet());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableFitableConfiguration degradationFitable(String degradationFitableId) {
        Object object = this.lock;
        synchronized (object) {
            this.degradationFitable = (String)ObjectUtils.nullIf((Object)degradationFitableId, (Object)"");
        }
        return this;
    }

    @Override
    public void remove() {
        this.parent.removeFitable(this.id);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Collection<String> aliases() {
        return this.aliases;
    }

    @Override
    public boolean containsAlias(String alias) {
        return StringUtils.isNotBlank((String)alias) && this.aliases.contains(alias);
    }

    @Override
    public Collection<String> tags() {
        return this.tags;
    }

    @Override
    public boolean containsTag(String tag) {
        return StringUtils.isNotBlank((String)tag) && this.tags.contains(tag);
    }

    @Override
    public String degradationFitable() {
        return this.degradationFitable;
    }
}

