/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableFitableConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableRouteConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableTrustConfiguration;
import com.huawei.fitframework.broker.conf.FitableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.GenericableType;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurableFitableConfiguration;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurableGenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurableRouteConfiguration;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurableTrustConfiguration;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultConfigurableGenericableConfiguration
implements ConfigurableGenericableConfiguration {
    private static final String LOCAL_ONLY_TAG = "localOnly";
    private final ConfigurableBrokerConfiguration parent;
    private final String id;
    private volatile String name;
    private volatile GenericableType type;
    private volatile Collection<String> tags;
    private final Map<String, ConfigurableGenericableParamConfiguration> params;
    private final Map<String, ConfigurableFitableConfiguration> fitables;
    private final ConfigurableTrustConfiguration trust;
    private final ConfigurableRouteConfiguration route;
    private final Object lock = new byte[0];

    public DefaultConfigurableGenericableConfiguration(ConfigurableBrokerConfiguration parent, String id) {
        this.parent = (ConfigurableBrokerConfiguration)Validation.notNull((Object)parent, (String)"The parent of a genericable configuration cannot be null.", (Object[])new Object[0]);
        this.id = Validation.notBlank((String)id, (String)"The id of a genericable cannot be blank.", (Object[])new Object[0]);
        this.name = "";
        this.type = GenericableType.DEFAULT;
        this.tags = Collections.emptySet();
        this.params = new ConcurrentHashMap<String, ConfigurableGenericableParamConfiguration>();
        this.fitables = new ConcurrentHashMap<String, ConfigurableFitableConfiguration>();
        this.trust = new DefaultConfigurableTrustConfiguration();
        this.route = new DefaultConfigurableRouteConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableGenericableConfiguration name(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.name = (String)ObjectUtils.nullIf((Object)name, (Object)"");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableGenericableConfiguration type(GenericableType type) {
        Object object = this.lock;
        synchronized (object) {
            this.type = (GenericableType)((Object)ObjectUtils.nullIf((Object)((Object)type), (Object)((Object)GenericableType.DEFAULT)));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableGenericableConfiguration tags(Collection<String> tags) {
        Object object = this.lock;
        synchronized (object) {
            this.tags = (Collection)ObjectUtils.nullIf(tags, Collections.emptySet());
        }
        return this;
    }

    @Override
    public ConfigurableGenericableParamConfiguration getOrCreateParam(String name) {
        return this.params.computeIfAbsent(Validation.notBlank((String)name, (String)"The name of parameter cannot be blank.", (Object[])new Object[0]), key -> new DefaultConfigurableGenericableParamConfiguration(this, (String)key));
    }

    @Override
    public ConfigurableFitableConfiguration getOrCreateFitable(String fitableId) {
        return this.fitables.computeIfAbsent(Validation.notBlank((String)fitableId, (String)"The id of fitable cannot be blank.", (Object[])new Object[0]), key -> new DefaultConfigurableFitableConfiguration(this, (String)key));
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public GenericableType type() {
        return this.type;
    }

    @Override
    public ConfigurableTrustConfiguration trust() {
        return this.trust;
    }

    @Override
    public ConfigurableRouteConfiguration route() {
        return this.route;
    }

    @Override
    public Collection<GenericableParamConfiguration> params() {
        return this.params.values().stream().map(GenericableParamConfiguration.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<GenericableParamConfiguration> param(String name) {
        return StringUtils.isBlank((String)name) ? Optional.empty() : Optional.ofNullable(this.params.get(name));
    }

    @Override
    public Collection<String> tags() {
        return this.tags;
    }

    @Override
    public boolean containsTag(String tag) {
        return StringUtils.isNotBlank((String)tag) && this.tags.contains(tag);
    }

    @Override
    public Collection<FitableConfiguration> fitables() {
        return this.fitables.values().stream().map(FitableConfiguration.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<FitableConfiguration> fitable(String fitableId) {
        return StringUtils.isBlank((String)fitableId) ? Optional.empty() : Optional.ofNullable(this.fitables.get(fitableId));
    }

    @Override
    public void removeParam(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.params.remove(name);
        }
    }

    @Override
    public void removeFitable(String fitableId) {
        if (StringUtils.isNotBlank((String)fitableId)) {
            this.fitables.remove(fitableId);
        }
    }

    @Override
    public void clearFitables() {
        this.fitables.clear();
    }

    @Override
    public void clearTags() {
        this.tags.clear();
    }

    @Override
    public void clearParams() {
        this.params.clear();
    }

    @Override
    public void remove() {
        this.parent.removeGenericable(this.id());
    }

    @Override
    public boolean localOnly() {
        return this.containsTag(LOCAL_ONLY_TAG);
    }
}

