/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBrokerConfigurationConfigurator
implements BrokerConfigurationConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileBrokerConfigurationConfigurator.class);
    private final File file;
    private final ConfigurationReader reader;

    public FileBrokerConfigurationConfigurator(File file, ConfigurationReader reader) {
        this.file = (File)Validation.notNull((Object)file, (String)"The file of configuration cannot be null.", (Object[])new Object[0]);
        this.reader = (ConfigurationReader)Validation.notNull((Object)reader, (String)"The reader for configuration cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public void configure(ConfigurableBrokerConfiguration destination, ConfigureMode mode) {
        if (!this.file.exists()) {
            log.debug("Ignore broker configuration because the file does not exist. [path={}]", (Object)FileUtils.path((File)this.file));
        } else if (!this.file.isFile()) {
            log.debug("Ignore broker configuration because the file is not a regular file. [path={}]", (Object)FileUtils.path((File)this.file));
        } else {
            Map<String, Object> values = this.load();
            log.info("Accept broker configuration from file. [path={}]", (Object)FileUtils.path((File)this.file));
            BrokerConfigurationConfigurator.values(values).configure(destination, mode);
        }
    }

    private Map<String, Object> load() {
        try {
            return this.reader.read(this.file);
        }
        catch (IOException e) {
            log.warn("Fail to load values from config file. [path={}]", (Object)FileUtils.path((File)this.file));
            throw new IllegalStateException(StringUtils.format((String)"Fail to load values from config file. [path={0}]", (Object[])new Object[]{FileUtils.path((File)this.file)}), e);
        }
    }
}

