/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarResourceBrokerConfigurationConfigurator
implements BrokerConfigurationConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JarResourceBrokerConfigurationConfigurator.class);
    private final File jar;
    private final String resourceKey;
    private final ConfigurationReader reader;

    public JarResourceBrokerConfigurationConfigurator(File jar, String resourceKey, ConfigurationReader reader) {
        this.jar = (File)Validation.notNull((Object)jar, (String)"The jar that contains broker configuration to load cannot be null.", (Object[])new Object[0]);
        this.resourceKey = Validation.notBlank((String)resourceKey, (String)"The resource key for broker configuration to load cannot be blank.", (Object[])new Object[0]);
        this.reader = (ConfigurationReader)Validation.notNull((Object)reader, (String)"The reader for broker configuration cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public void configure(ConfigurableBrokerConfiguration destination, ConfigureMode mode) {
        Map<String, Object> values = this.read();
        BrokerConfigurationConfigurator.values(values).configure(destination, mode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> read() {
        try (JarFile file = new JarFile(this.jar);){
            Map<String, Object> map = this.read(file);
            return map;
        }
        catch (IOException e) {
            log.warn("Fail to load broker configurations from JAR entry. [jar={}, entry={}]", (Object)FileUtils.path((File)this.jar), (Object)this.resourceKey);
            throw new IllegalStateException(StringUtils.format((String)"Fail to load broker configurations from JAR entry. [jar={0}, entry={1}]", (Object[])new Object[]{FileUtils.path((File)this.jar), this.resourceKey}), e);
        }
    }

    private Map<String, Object> read(JarFile file) throws IOException {
        ZipEntry entry = file.getEntry(this.resourceKey);
        if (entry == null) {
            log.info("Skip to load broker configurations: entry not found in JAR. [jar={}, entry={}]", (Object)FileUtils.path((File)this.jar), (Object)this.resourceKey);
            return Collections.emptyMap();
        }
        if (entry.isDirectory()) {
            log.info("Skip to load broker configurations: entry is a directory. [jar={}, entry={}]", (Object)FileUtils.path((File)this.jar), (Object)this.resourceKey);
            return Collections.emptyMap();
        }
        try (InputStream in = file.getInputStream(entry);){
            Map<String, Object> values = this.reader.read(in);
            log.info("Accept broker configuration from JAR file. [file={}]", (Object)file.getName());
            Map<String, Object> map = values;
            return map;
        }
    }
}

