/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.util.MapAggregator;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigurationReader
implements ConfigurationReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertiesConfigurationReader.class);
    public static final int DEFAULT_ALLOWED_VALUE_LENGTH = 512;
    public static final ConfigurationReader INSTANCE = new PropertiesConfigurationReader(512);
    private final int allowedValueLength;

    public PropertiesConfigurationReader(int allowedValueLength) {
        this.allowedValueLength = Validation.greaterThan((int)allowedValueLength, (int)0, (String)"Allowed value length should greater than 0. [allowedValueLength={0}]", (Object[])new Object[]{allowedValueLength});
    }

    @Override
    public Map<String, Object> read(InputStream in) throws IOException {
        Validation.notNull((Object)in, (String)"The input stream to read configuration values cannot be null.", (Object[])new Object[0]);
        Properties properties = new Properties();
        properties.load(in);
        return MapAggregator.create('.').aggregate(properties.stringPropertyNames(), properties::getProperty, value -> StringUtils.isNotBlank((String)value) && value.length() <= this.allowedValueLength);
    }
}

