/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ValueUtils {
    private ValueUtils() {
    }

    public static String stringValue(Map<String, Object> values, String key) {
        return (String)ObjectUtils.nullIf(ValueUtils.cast(values.get(key)), (Object)"");
    }

    public static String stringValue(Map<String, Object> values, String key, String defaultValue) {
        String value = ValueUtils.stringValue(values, key);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    private static Integer integerValue(Map<String, Object> values, String key) {
        Object value = values.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        String stringValue = value.toString();
        if (StringUtils.isBlank((String)stringValue)) {
            return null;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(StringUtils.format((String)"Integer required. [name={0}, value={1}]", (Object[])new Object[]{key, value}));
        }
    }

    public static Integer integerValue(Map<String, Object> values, String key, Integer defaultValue) {
        Integer value = ValueUtils.integerValue(values, key);
        return (Integer)ObjectUtils.nullIf((Object)value, (Object)defaultValue);
    }

    public static Map<String, Object> children(Map<String, Object> values, String key) {
        Object value = values.get(key);
        return (Map)ValueUtils.cast(ObjectUtils.nullIf((Object)value, Collections.emptyMap()));
    }

    public static Collection<String> stringCollection(Map<String, Object> values, String key, Supplier<Collection<String>> collectionFactory) {
        String value = ValueUtils.stringValue(values, key);
        return Arrays.stream(StringUtils.split((String)value, (char)',')).map(StringUtils::trim).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(collectionFactory));
    }

    public static <T> T cast(Object value) {
        Object actual = value;
        return (T)actual;
    }
}

