/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.support;

import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.ByteSerializer;
import com.huawei.fitframework.serialization.util.VaryingNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTagLengthValues
implements TagLengthValues {
    private static final byte[] EMPTY_VALUE = new byte[0];
    private final Map<Integer, byte[]> tagValues = new ConcurrentHashMap<Integer, byte[]>();

    @Override
    public Set<Integer> getTags() {
        return this.tagValues.keySet();
    }

    @Override
    public byte[] getValue(int tag) {
        return this.tagValues.getOrDefault(tag, EMPTY_VALUE);
    }

    @Override
    public void putTag(int tag, byte[] value) {
        Validation.notNull((Object)value, (String)"Cannot put null value to Tag-Length-Value, please use 'remove(int tag)' method. [tag={0}]", (Object[])new Object[]{tag});
        this.tagValues.put(tag, value);
    }

    @Override
    public void putTags(Map<Integer, byte[]> tagValues) {
        if (MapUtils.isEmpty(tagValues)) {
            return;
        }
        tagValues.forEach(this::putTag);
    }

    @Override
    public void remove(int tag) {
        this.tagValues.remove(tag);
    }

    public static class Serializer
    implements ByteSerializer<TagLengthValues> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(TagLengthValues tagValues, OutputStream out) throws IOException {
            for (Integer tag : tagValues.getTags()) {
                if (tag == null) continue;
                out.write(VaryingNumber.valueOf((int)tag).bytes());
                byte[] value = tagValues.getValue(tag);
                out.write(VaryingNumber.valueOf((int)value.length).bytes());
                out.write(value);
            }
        }

        public TagLengthValues deserialize(InputStream in) throws IOException {
            VaryingNumber tag;
            DefaultTagLengthValues values = new DefaultTagLengthValues();
            while ((tag = (VaryingNumber)VaryingNumber.serializer().deserialize(in)) != null) {
                int length = ((VaryingNumber)VaryingNumber.serializer().deserialize(in)).intValue();
                byte[] value = IoUtils.read((InputStream)in, (int)length);
                values.putTag(tag.intValue(), value);
            }
            return values;
        }
    }
}

