/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.exception;

import java.util.Arrays;
import lombok.Generated;

public enum SystemError {
    USER_ERROR(2130706693, "exception from user code occurred", Category.GENERAL),
    ROUTING_NO_AVAILABLE_FITABLE_ERROR(2130706945, "Available fitable not found. [detail: {0}]", Category.ROUTE),
    ROUTE_RULE_NOT_FOUND_ERROR(2130706946, "Routing rule not found. [detail: {0}]", Category.ROUTE),
    ROUTE_DEFAULT_CONFIG_NOT_FOUND_ERROR(2130706947, "Config of default fitable id not found. [detail: {0}]", Category.ROUTE),
    PROTOBUF_SERIALIZATION_PROCESSING_ERROR(2130707457, "Protobuf serialization to bytes error. [detail: {0}]", Category.SERIALIZATION),
    PROTOBUF_DESERIALIZATION_PROCESSING_ERROR(2130707458, "Protobuf deserialization from bytes error. [detail: {0}]", Category.SERIALIZATION),
    JSON_SERIALIZATION_PROCESSING_ERROR(2130707459, "Json serialization to bytes error. [detail: {0}]", Category.SERIALIZATION),
    JSON_DESERIALIZATION_PROCESSING_ERROR(2130707460, "Json deserialization from bytes error. [detail: {0}]", Category.SERIALIZATION),
    SERIALIZATION_FORMAT_ERROR(2130707461, "Data type not supported. [detail: {0}]", Category.SERIALIZATION),
    DEFAULT_NETWORK_ERROR(2130707712, "Network error.", Category.NETWORK),
    TIMEOUT_ERROR(2130707713, "Timeout error.", Category.NETWORK),
    NETWORK_CONNECTION_ERROR(2130707714, "Connection failed.", Category.NETWORK),
    SENDING_DATA_FAILED_ERROR(2130707715, "Failed to send data.", Category.NETWORK),
    RECEIVE_DATA_FAILED_ERROR(2130707716, "Failed to receive data.", Category.NETWORK),
    INVALID_REQUEST_METADATA_ERROR(2130707717, "Invalid request metadata.", Category.NETWORK),
    INVALID_RESPONSE_METADATA_ERROR(2130707718, "Invalid response metadata.", Category.NETWORK),
    INVALID_REQUEST_VERSION_ERROR(2130707719, "Invalid request version.", Category.NETWORK),
    MESH_INTERRUPTED_ERROR(2130707968, "Mesh failed.", Category.MESH),
    MESH_IGNORABLE_ERROR(2130707969, "Ignorable mesh error.", Category.MESH);

    private final int code;
    private final String message;
    private final Category category;

    private SystemError(int code, String message, Category category) {
        this.code = code;
        this.message = message;
        this.category = category;
    }

    public static Category fromCode(int code) {
        return Arrays.stream(SystemError.values()).filter(systemError -> systemError.getCode() == code).map(SystemError::getCategory).findFirst().orElse(Category.GENERAL);
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    public static enum Category {
        GENERAL,
        ROUTE,
        LOAD_BALANCE,
        SERIALIZATION,
        NETWORK,
        MESH;

    }
}

