/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime;

import com.huawei.fitframework.conf.startup.StartupConfig;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SystemDirectories {
    private static final String CONF = "conf";
    private static final String CONVERTER = "converter";
    private static final String EXTENSIONS = "extensions";
    private static final String LIB = "lib";
    private static final String PLATFORM = "platform";
    private static final String PLUGINS = "plugins";
    private static final String SHARED = "shared";
    private static final String THIRD_PARTY = "third-party";
    private static final File CURRENT_DIRECTORY = FileUtils.canonicalize((File)new File("."));
    private static Framework framework;
    private static final List<Extension> EXTENSION_LIST;
    private static final List<Plugin> PLUGIN_LIST;
    private static final Map<String, Plugin> PLUGIN_CREATED_MAP;
    private static volatile boolean initialized;

    public static void initialize(String frameworkFolder, List<String> extensionFolders, List<String> pluginFolders) {
        if (initialized) {
            return;
        }
        SystemDirectories.initializeFramework(frameworkFolder);
        SystemDirectories.initialExtensions(extensionFolders);
        SystemDirectories.initialPlugins(pluginFolders);
        initialized = true;
    }

    public static Plugin getPlugin(File pluginRoot) {
        String rootPath = FileUtils.canonicalize((File)pluginRoot).getPath();
        if (PLUGIN_CREATED_MAP.containsKey(rootPath)) {
            return PLUGIN_CREATED_MAP.get(rootPath);
        }
        Plugin plugin = new Plugin(pluginRoot);
        PLUGIN_CREATED_MAP.put(rootPath, plugin);
        return plugin;
    }

    public static Plugin getPlugin(StartupConfig.Plugin pluginConfig) {
        String rootPath = FileUtils.canonicalize((File)pluginConfig.file()).getPath();
        if (PLUGIN_CREATED_MAP.containsKey(rootPath)) {
            return PLUGIN_CREATED_MAP.get(rootPath);
        }
        Plugin plugin = new Plugin(pluginConfig);
        PLUGIN_CREATED_MAP.put(rootPath, plugin);
        return plugin;
    }

    private static void initializeFramework(String frameworkFolder) {
        framework = StringUtils.isBlank((String)frameworkFolder) ? new Framework(CURRENT_DIRECTORY) : new Framework(FileUtils.canonicalize((File)new File(frameworkFolder)));
    }

    private static void initialExtensions(List<String> extensionFolders) {
        if (CollectionUtils.isNotEmpty(extensionFolders)) {
            EXTENSION_LIST.clear();
            EXTENSION_LIST.addAll(extensionFolders.stream().filter(StringUtils::isNotBlank).map(File::new).map(FileUtils::canonicalize).map(Extension::new).collect(Collectors.toList()));
        }
    }

    private static void initialPlugins(List<String> pluginFolders) {
        if (CollectionUtils.isNotEmpty(pluginFolders)) {
            PLUGIN_LIST.clear();
            PLUGIN_LIST.addAll(pluginFolders.stream().filter(StringUtils::isNotBlank).map(File::new).map(FileUtils::canonicalize).map(SystemDirectories::getPlugin).collect(Collectors.toList()));
        }
    }

    public static Framework framework() {
        Validation.isTrue((boolean)initialized, (String)"SystemDirectory has not been initialized.", (Object[])new Object[0]);
        return framework;
    }

    public static List<Extension> extensions() {
        Validation.isTrue((boolean)initialized, (String)"SystemDirectory has not been initialized.", (Object[])new Object[0]);
        return Collections.unmodifiableList(EXTENSION_LIST);
    }

    public static List<Plugin> plugins() {
        Validation.isTrue((boolean)initialized, (String)"SystemDirectory has not been initialized.", (Object[])new Object[0]);
        return Collections.unmodifiableList(PLUGIN_LIST);
    }

    public static List<Plugin> allPlugins() {
        Validation.isTrue((boolean)initialized, (String)"SystemDirectory has not been initialized.", (Object[])new Object[0]);
        return CollectionUtils.connect((List[])new List[]{PLUGIN_LIST, framework.plugins});
    }

    static {
        EXTENSION_LIST = new ArrayList<Extension>();
        PLUGIN_LIST = new ArrayList<Plugin>();
        PLUGIN_CREATED_MAP = new HashMap<String, Plugin>();
        initialized = false;
    }

    public static class Platform
    implements SystemDirectory {
        private final String name;
        private final File root;
        private final File converter;
        private final List<Extension> extensions = new ArrayList<Extension>();
        private final File lib;
        private final File thirdParty;

        public Platform(File platformRoot) {
            File[] extensionDirectories;
            this.root = FileUtils.canonicalize((File)platformRoot);
            this.name = this.root.getName();
            Path rootPath = this.root.toPath();
            this.converter = rootPath.resolve(SystemDirectories.CONVERTER).toFile();
            File extensionParentDirectory = rootPath.resolve(SystemDirectories.EXTENSIONS).toFile();
            if (extensionParentDirectory.isDirectory() && (extensionDirectories = extensionParentDirectory.listFiles()) != null) {
                this.extensions.addAll(Stream.of(extensionDirectories).filter(Objects::nonNull).map(Extension::new).collect(Collectors.toList()));
            }
            this.lib = rootPath.resolve(SystemDirectories.LIB).toFile();
            this.thirdParty = rootPath.resolve(SystemDirectories.THIRD_PARTY).toFile();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public File root() {
            return this.root;
        }

        public final File converter() {
            return this.converter;
        }

        public final List<Extension> extensions() {
            return Collections.unmodifiableList(this.extensions);
        }

        public final File lib() {
            return this.lib;
        }

        public final File thirdParty() {
            return this.thirdParty;
        }
    }

    public static class Shared
    implements SystemDirectory {
        private final String name;
        private final File root;

        public Shared(File sharedRoot) {
            this.root = FileUtils.canonicalize((File)sharedRoot);
            this.name = this.root.getName();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public File root() {
            return this.root;
        }
    }

    public static class Plugin
    implements SystemDirectory {
        private final String name;
        private final File root;
        private final File conf;
        private final Platform platform;
        private final File lib;
        private final Shared shared;
        private final File thirdParty;

        public Plugin(File pluginRoot) {
            this.root = FileUtils.canonicalize((File)pluginRoot);
            this.name = this.root.getName();
            Path rootPath = FileUtils.canonicalize((File)pluginRoot).toPath();
            this.conf = rootPath.resolve(SystemDirectories.CONF).toFile();
            this.platform = new Platform(rootPath.resolve(SystemDirectories.PLATFORM).toFile());
            this.lib = rootPath.resolve(SystemDirectories.LIB).toFile();
            this.shared = new Shared(rootPath.resolve(SystemDirectories.SHARED).toFile());
            this.thirdParty = rootPath.resolve(SystemDirectories.THIRD_PARTY).toFile();
        }

        public Plugin(StartupConfig.Plugin plugin) {
            this.root = FileUtils.canonicalize((File)plugin.file());
            this.name = plugin.name();
            Path rootPath = this.root.toPath();
            this.conf = rootPath.resolve(SystemDirectories.CONF).toFile();
            this.platform = new Platform(rootPath.resolve(SystemDirectories.PLATFORM).toFile());
            this.lib = FileUtils.canonicalize((File)plugin.lib());
            this.shared = new Shared(rootPath.resolve(SystemDirectories.SHARED).toFile());
            this.thirdParty = FileUtils.canonicalize((File)plugin.thirdParty());
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final File root() {
            return this.root;
        }

        public final File conf() {
            return this.conf;
        }

        public final Platform platform() {
            return this.platform;
        }

        public final File lib() {
            return this.lib;
        }

        public final Shared shared() {
            return this.shared;
        }

        public final File thirdParty() {
            return this.thirdParty;
        }
    }

    public static class Extension
    implements SystemDirectory {
        private final String name;
        private final File root;
        private final Platform platform;
        private final File lib;
        private final Shared shared;
        private final File thirdParty;

        public Extension(File extensionRoot) {
            this.root = FileUtils.canonicalize((File)extensionRoot);
            this.name = this.root.getName();
            Path rootPath = FileUtils.canonicalize((File)extensionRoot).toPath();
            this.platform = new Platform(rootPath.resolve(SystemDirectories.PLATFORM).toFile());
            this.lib = rootPath.resolve(SystemDirectories.LIB).toFile();
            this.shared = new Shared(rootPath.resolve(SystemDirectories.SHARED).toFile());
            this.thirdParty = rootPath.resolve(SystemDirectories.THIRD_PARTY).toFile();
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final File root() {
            return this.root;
        }

        public final Platform platform() {
            return this.platform;
        }

        public final File lib() {
            return this.lib;
        }

        public final Shared shared() {
            return this.shared;
        }

        public final File thirdParty() {
            return this.thirdParty;
        }
    }

    public static class Framework
    implements SystemDirectory {
        private final String name;
        private final File root;
        private final File conf;
        private final Platform platform;
        private final List<Plugin> plugins = new ArrayList<Plugin>();
        private final Shared shared;

        public Framework(File frameworkRoot) {
            File[] pluginDirectories;
            this.root = FileUtils.canonicalize((File)frameworkRoot);
            this.name = this.root.getName();
            Path rootPath = this.root.toPath();
            this.conf = rootPath.resolve(SystemDirectories.CONF).toFile();
            this.platform = new Platform(rootPath.resolve(SystemDirectories.PLATFORM).toFile());
            File pluginParentDirectory = rootPath.resolve(SystemDirectories.PLUGINS).toFile();
            if (pluginParentDirectory.isDirectory() && (pluginDirectories = pluginParentDirectory.listFiles()) != null) {
                this.plugins.addAll(Stream.of(pluginDirectories).filter(Objects::nonNull).map(SystemDirectories::getPlugin).collect(Collectors.toList()));
            }
            this.shared = new Shared(rootPath.resolve(SystemDirectories.SHARED).toFile());
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final File root() {
            return this.root;
        }

        public final File conf() {
            return this.conf;
        }

        public final Platform platform() {
            return this.platform;
        }

        public final List<Plugin> plugins() {
            return Collections.unmodifiableList(this.plugins);
        }

        public final Shared shared() {
            return this.shared;
        }
    }

    public static interface SystemDirectory {
        public String name();

        public File root();
    }
}

