/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry.registry;

import com.huawei.fit.registry.GetRegistryAddresses;
import com.huawei.fit.registry.entity.Address;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class AddressRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddressRepository.class);
    private final Address registryAddress;

    public AddressRepository(@Value(value="${matata.registry.host}") String host, @Value(value="${matata.registry.port}") Integer port, @Value(value="${matata.registry.protocol}") Integer protocol, @Value(value="${matata.registry.formats}") List<Integer> formats, @Value(value="${worker.environment}") String environment) {
        Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
        log.info("Config worker.environment is {}.", (Object)environment);
        String actualHost = Validation.notBlank((String)host, (String)"No registry host.", (Object[])new Object[0]);
        int actualPort = (Integer)Validation.notNull((Object)port, (String)"No registry port", (Object[])new Object[0]);
        int actualProtocol = (Integer)Validation.notNull((Object)protocol, (String)"No registry protocol", (Object[])new Object[0]);
        List actualFormats = (List)Validation.notNull(formats, (String)"No registry formats", (Object[])new Object[0]);
        this.registryAddress = Address.builder().id(actualHost).host(actualHost).port(Integer.valueOf(actualPort)).protocol(Integer.valueOf(actualProtocol)).formats(actualFormats.stream().filter(Objects::nonNull).collect(Collectors.toList())).environment(environment).build();
        log.info("Registry address is {}.", (Object)this.registryAddress);
    }

    @Fitable(generic=GetRegistryAddresses.class, id="eb76db86dde24d36bf492a40ee289033")
    public List<Address> getRegistryAddresses() {
        log.debug("Registry addresses is [{}].", (Object)this.registryAddress);
        return Collections.singletonList(this.registryAddress);
    }
}

