/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class AbstractZip<T extends AbstractZip<?>> {
    private final File zipFile;
    private final Charset charset;
    private boolean override;

    public AbstractZip(File zipFile, Charset charset) {
        this.zipFile = Validation.notNull(zipFile, "The zip file to process cannot be null.", new Object[0]);
        this.charset = ObjectUtils.nullIf(charset, FileUtils.DEFAULT_CHARSET);
    }

    public T override(boolean override) {
        this.override = override;
        return (T)this;
    }

    protected final File file() {
        return this.zipFile;
    }

    protected final Charset charset() {
        return this.charset;
    }

    protected final boolean override() {
        return this.override;
    }

    public abstract void start() throws IOException;
}

