/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.workflow;

import com.huawei.fitframework.workflow.AbstractNode;
import com.huawei.fitframework.workflow.ConditionalNode;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Line;
import com.huawei.fitframework.workflow.Node;
import com.huawei.fitframework.workflow.Output;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractConditionalNode
extends AbstractNode
implements ConditionalNode {
    private final Set<Integer> lineNos = new HashSet<Integer>();

    @Override
    public void addFollowedLineNo(int lineNo) {
        this.lineNos.add(lineNo);
    }

    @Override
    public Optional<Node> getNextNode(Input input) {
        return this.getLines().stream().filter(line -> line.isSatisfied(input)).map(Line::getTo).findFirst();
    }

    @Override
    public Output process(Input input) {
        return null;
    }

    @Override
    public List<Line> getLines() {
        List lines = this.lineNos.stream().map(this.getWorkflow()::getLine).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Collections.unmodifiableList(lines);
    }
}

