/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.workflow;

import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.workflow.Putable;
import com.huawei.fitframework.workflow.exception.ClassTypeMismatchException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPutable
implements Putable {
    private final Map<String, Object> map = new HashMap<String, Object>();

    protected AbstractPutable(Map<String, Object> map) {
        this.map.putAll(map);
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        Validation.notNull(clazz, (String)"No class. [key={0}]", (Object[])new Object[]{key});
        Class actualClass = ReflectionUtils.ignorePrimitiveClass(clazz);
        Object value = this.get(key);
        if (value == null || actualClass.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        String message = StringUtils.format((String)"Class type mismatch. [key={0}, expectedClass={1}, actualClass={2}]", (Object[])new Object[]{key, clazz.getName(), value.getClass().getName()});
        throw new ClassTypeMismatchException(message);
    }

    @Override
    public Object require(String key) {
        return Validation.notNull((Object)this.get(key), () -> new IllegalStateException(StringUtils.format((String)"No required info. [key={0}]", (Object[])new Object[]{key})));
    }

    @Override
    public <T> T require(String key, Class<T> clazz) {
        return (T)Validation.notNull(this.get(key, clazz), () -> new IllegalStateException(StringUtils.format((String)"No required info. [key={0}, class={1}]", (Object[])new Object[]{key, clazz.getName()})));
    }

    @Override
    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.map);
    }
}

