/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.workflow.support;

import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Line;
import com.huawei.fitframework.workflow.Node;
import java.util.function.Predicate;

public class DefaultLine
implements Line {
    private final int no;
    private final Node from;
    private final Node to;
    private final Predicate<Input> condition;

    private DefaultLine(int no, Node from, Node to, Predicate<Input> condition) {
        this.no = Validation.greaterThan((int)no, (int)0, (String)"Line no is less than 1. [no={0}]", (Object[])new Object[]{no});
        this.from = (Node)Validation.notNull((Object)from, (String)"From node is null. [no={0}]", (Object[])new Object[]{this.no});
        this.to = (Node)Validation.notNull((Object)to, (String)"To node is null. [no={0}]", (Object[])new Object[]{this.no});
        this.condition = (Predicate)Validation.notNull(condition, (String)"No line condition. [no={0}]", (Object[])new Object[]{this.no});
    }

    @Override
    public boolean isSatisfied(Input input) {
        return this.condition.test(input);
    }

    @Override
    public int getNo() {
        return this.no;
    }

    @Override
    public Node getFrom() {
        return this.from;
    }

    @Override
    public Node getTo() {
        return this.to;
    }

    public static final class Builder
    implements Line.Builder {
        private int no;
        private Node from;
        private Node to;
        private Predicate<Input> condition;

        @Override
        public Line.Builder no(int no) {
            this.no = no;
            return this;
        }

        @Override
        public Line.Builder from(Node fromNode) {
            this.from = fromNode;
            return this;
        }

        @Override
        public Line.Builder to(Node toNode) {
            this.to = toNode;
            return this;
        }

        @Override
        public Line.Builder isSatisfied(Predicate<Input> condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public Line build() {
            return new DefaultLine(this.no, this.from, this.to, this.condition);
        }
    }
}

