/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.workflow.support;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Line;
import com.huawei.fitframework.workflow.Node;
import com.huawei.fitframework.workflow.Start;
import com.huawei.fitframework.workflow.Workflow;
import com.huawei.fitframework.workflow.WorkflowInstance;
import com.huawei.fitframework.workflow.support.DefaultWorkflowInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflow
implements Workflow {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflow.class);
    private final String name;
    private final Map<String, Node> nodeNameNodeMappings;
    private final Map<Integer, Line> lineNoLineMappings;

    private DefaultWorkflow(String name, Map<String, Node> nodeNameNodeMappings, Map<Integer, Line> lineNoLineMappings) {
        this.name = Validation.notBlank((String)name, (String)"No workflow name.", (Object[])new Object[0]);
        this.nodeNameNodeMappings = nodeNameNodeMappings;
        this.lineNoLineMappings = lineNoLineMappings;
        this.nodeNameNodeMappings.values().forEach(node -> node.setWorkflow(this));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WorkflowInstance create() {
        return new DefaultWorkflowInstance(this);
    }

    @Override
    public Optional<Node> getStartNode() {
        return this.nodeNameNodeMappings.values().stream().filter(Objects::nonNull).filter(node -> Start.class.isAssignableFrom(node.getClass())).filter(node -> Node.class.isAssignableFrom(node.getClass())).map(Node.class::cast).findFirst();
    }

    @Override
    public Optional<Node> getNode(String nodeName) {
        return Optional.ofNullable(this.nodeNameNodeMappings.get(nodeName));
    }

    @Override
    public Optional<Line> getLine(int no) {
        return Optional.ofNullable(this.lineNoLineMappings.get(no));
    }

    public static final class Builder
    implements Workflow.Builder {
        private String name;
        private final Map<String, Node> nodeNameNodeMappings = new HashMap<String, Node>();
        private final Map<Integer, Line> lineNoLineMappings = new HashMap<Integer, Line>();
        private final Map<String, Set<String>> existLines = new HashMap<String, Set<String>>();

        @Override
        public Workflow.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Workflow.Builder addNode(Node node) {
            if (node == null) {
                return this;
            }
            this.checkNode(node);
            this.nodeNameNodeMappings.put(node.getName(), node);
            return this;
        }

        private void checkNode(Node node) {
            Node existNode = this.nodeNameNodeMappings.get(node.getName());
            if (existNode == null) {
                return;
            }
            if (existNode == node) {
                return;
            }
            throw new IllegalStateException(StringUtils.format((String)"Check node failed: it has been exist. [nodeName={0}]", (Object[])new Object[]{node.getName()}));
        }

        @Override
        public Workflow.Builder addNodes(List<Node> nodes) {
            if (CollectionUtils.isEmpty(nodes)) {
                return this;
            }
            nodes.forEach(this::addNode);
            return this;
        }

        @Override
        public Workflow.Builder addLine(Node fromNode, Node toNode) {
            this.addLine(fromNode, toNode, input -> true);
            return this;
        }

        @Override
        public Workflow.Builder addLine(Node fromNode, Node toNode, Predicate<Input> condition) {
            if (fromNode == null || toNode == null || condition == null) {
                return this;
            }
            this.addNode(fromNode);
            this.addNode(toNode);
            if (this.isLineExist(fromNode.getName(), toNode.getName())) {
                return this;
            }
            this.addLineRel(fromNode, toNode, condition);
            return this;
        }

        private boolean isLineExist(String fromNodeName, String toNodeName) {
            Set<String> toNodeNames = this.existLines.get(fromNodeName);
            if (CollectionUtils.isEmpty(toNodeNames)) {
                return false;
            }
            return toNodeNames.contains(toNodeName);
        }

        private void addLineRel(Node fromNode, Node toNode, Predicate<Input> condition) {
            int currentLineNo = this.lineNoLineMappings.size() + 1;
            Line line = Line.builder().no(currentLineNo).from(fromNode).to(toNode).isSatisfied(condition).build();
            this.lineNoLineMappings.put(currentLineNo, line);
            fromNode.addFollowedLineNo(currentLineNo);
            Set toNodeNames = this.existLines.computeIfAbsent(fromNode.getName(), key -> new HashSet());
            toNodeNames.add(toNode.getName());
        }

        @Override
        public Workflow build() {
            return new DefaultWorkflow(this.name, this.nodeNameNodeMappings, this.lineNoLineMappings);
        }
    }
}

