/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.workflow.support;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.workflow.Input;
import com.huawei.fitframework.workflow.Node;
import com.huawei.fitframework.workflow.Output;
import com.huawei.fitframework.workflow.Stop;
import com.huawei.fitframework.workflow.Workflow;
import com.huawei.fitframework.workflow.WorkflowInstance;
import com.huawei.fitframework.workflow.exception.WorkflowException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowInstance
implements WorkflowInstance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowInstance.class);
    private final Workflow workflow;

    DefaultWorkflowInstance(Workflow workflow) {
        this.workflow = workflow;
    }

    @Override
    public Output start(Input input) {
        Node cur = this.getWorkflow().getStartNode().orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No start node. [workflow={0}]", (Object[])new Object[]{this.workflow.getName()})));
        Input in = input;
        while (cur != null && !this.isStopNode(cur)) {
            Output out = this.processCurrentNode(cur, in);
            in = Input.builder(in).putAll(out).build();
            cur = cur.getNextNode(in).orElse(null);
        }
        Validation.notNull((Object)cur, () -> new IllegalStateException(StringUtils.format((String)"No stop node. [workflow={0}]", (Object[])new Object[]{this.workflow.getName()})));
        return cur.process(in);
    }

    private boolean isStopNode(Node node) {
        return Stop.class.isAssignableFrom(node.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Output processCurrentNode(Node cur, Input in) {
        Output out = null;
        cur.validate(in);
        try {
            try {
                cur.before(in);
            }
            catch (WorkflowException e) {
                log.debug("Execute before step error, skip. [node={}, exception={}, message={}]", new Object[]{cur.getName(), ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
            }
            try {
                out = cur.process(in);
            }
            catch (WorkflowException e) {
                out = cur.error(in, e);
            }
        }
        catch (Throwable throwable) {
            try {
                cur.after(in, out);
            }
            catch (WorkflowException e) {
                log.debug("Execute after step error, skip. [node={}, exception={}, message={}]", new Object[]{cur.getName(), ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
            }
            throw throwable;
        }
        try {
            cur.after(in, out);
        }
        catch (WorkflowException e) {
            log.debug("Execute after step error, skip. [node={}, exception={}, message={}]", new Object[]{cur.getName(), ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
        }
        return out;
    }

    @Override
    public Workflow getWorkflow() {
        return this.workflow;
    }
}

