/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat;

import com.huawei.fit.broker.server.StartServer;
import com.huawei.fit.broker.server.StopServer;
import com.huawei.fit.registry.entity.Address;
import com.huawei.fitLab.core.broker.server.GetServerAddress;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.plugin.http.server.tomcat.config.ConnectorFactory;
import com.huawei.fitframework.plugin.http.server.tomcat.config.Monitor;
import com.huawei.fitframework.plugin.http.server.tomcat.config.TomcatConfigurator;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import com.huawei.fitframework.plugin.http.server.tomcat.config.support.SslConfigMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public final class HttpServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpServer.class);
    private static final int PROTOCOL_HTTP = 2;
    private final String workerId;
    private final Tomcat tomcat;
    private final WebConfigProvider provider;
    private final TomcatConfigurator tomcatConfigurator;
    private final List<Monitor> monitors;
    private final ExecutorService executor;
    private Address address;

    public HttpServer(WebConfigProvider provider, ConnectorFactory connectorFactory, TomcatConfigurator tomcatConfigurator, @Value(value="${server.id}") String workerId) {
        this.workerId = workerId;
        this.tomcat = new Tomcat();
        this.provider = provider;
        this.tomcatConfigurator = tomcatConfigurator;
        this.monitors = new ArrayList<Monitor>();
        if (this.provider.sslEnable()) {
            this.monitors.add(new SslConfigMonitor(this.tomcat, this.provider, connectorFactory));
        }
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Fitable(generic=StartServer.class, id="3a1f0c9fce3b43b98049fcbdcd279b90")
    public Address startServer() {
        this.tomcatConfigurator.config(this.tomcat);
        try {
            this.tomcat.start();
            this.monitors.forEach(Monitor::start);
            log.info("---------- start http server successful on ({}:{}). ----------", (Object)this.provider.getServerHost(), (Object)this.provider.getServerPorts().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
            this.executor.execute(() -> this.tomcat.getServer().await());
            this.address = Address.builder().host(this.provider.getServerHost()).port(this.provider.getServerPorts().iterator().next()).id(this.workerId).protocol(Integer.valueOf(2)).build();
            return this.address;
        }
        catch (LifecycleException e) {
            log.error("Fail to start http server. msg: [{}].", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Fitable(generic=StopServer.class, id="5e094736b1f14fc983bbfeb700e21d21")
    public void stopServer() {
        try {
            this.tomcat.stop();
            this.monitors.forEach(Monitor::stop);
            this.executor.shutdownNow();
        }
        catch (LifecycleException e) {
            log.error("stop tomcat failed.msg:[{}]", (Object)e.getMessage(), (Object)e);
        }
    }

    @Fitable(generic=GetServerAddress.class, id="f6f5188811c2404496045966226fde37")
    public Address getServerAddress() {
        return this.address;
    }
}

