/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.plugin.http.server.tomcat.config.ConnectorBuilder;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;

public abstract class AbstractConnectorBuilder
implements ConnectorBuilder {
    @Override
    public Connector build(int port, WebConfigProvider provider) {
        Connector connector = this.createConnector();
        connector.setPort(port);
        connector.setMaxPostSize(provider.getAllowedMaxPostSize());
        this.setConnectorServerAddress(provider, connector);
        connector.setEncodedSolidusHandling("decode");
        connector.setProperty("relaxedQueryChars", "[]{}");
        Optional.ofNullable(provider.getAcceptCount()).ifPresent(acceptCount -> connector.setProperty("acceptCount", String.valueOf(acceptCount)));
        Optional.ofNullable(provider.getMaxConnections()).ifPresent(maxConnections -> connector.setProperty("maxConnections", String.valueOf(maxConnections)));
        Optional.ofNullable(provider.getMaxThreads()).ifPresent(maxThreads -> connector.setProperty("maxThreads", String.valueOf(maxThreads)));
        this.setConnectorProperties(connector, provider);
        return connector;
    }

    private void setConnectorServerAddress(WebConfigProvider provider, Connector connector) {
        if (this.canSetAddress(provider, connector)) {
            try {
                AbstractProtocol protocol = (AbstractProtocol)ObjectUtils.cast((Object)connector.getProtocolHandler());
                protocol.setAddress(InetAddress.getByName(provider.getServerAddress()));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Failed to build connector: the server address is incorrect.");
            }
        }
    }

    private boolean canSetAddress(WebConfigProvider provider, Connector connector) {
        return connector.getProtocolHandler() instanceof AbstractProtocol && connector.getProtocolHandler() != null && StringUtils.isNotBlank((String)provider.getServerAddress());
    }

    protected Connector createConnector() {
        return new Connector();
    }

    protected void setConnectorProperties(Connector connector, WebConfigProvider provider) {
    }
}

