/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.plugin.http.server.tomcat.config.ConnectorBuilder;
import com.huawei.fitframework.plugin.http.server.tomcat.config.ConnectorFactory;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebProtocol;
import com.huawei.fitframework.plugin.http.server.tomcat.config.support.HttpConnectorBuilder;
import com.huawei.fitframework.plugin.http.server.tomcat.config.support.HttpsConnectorBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.catalina.connector.Connector;

@Fitable
public class DefaultConnectorFactory
implements ConnectorFactory {
    private final List<ConnectorBuilder> builders = new ArrayList<ConnectorBuilder>();

    public DefaultConnectorFactory(BrokerClient brokerClient) {
        this.builders.add(new HttpConnectorBuilder());
        this.builders.add(new HttpsConnectorBuilder(brokerClient));
    }

    @Override
    public List<Connector> createConnectors(WebConfigProvider provider) {
        WebProtocol protocol = provider.getProtocol();
        ConnectorBuilder connectorBuilder = this.builders.stream().filter(builder -> builder.protocol() == protocol).findFirst().orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"Unsupported protocol. [protocol={0}]", (Object[])new Object[]{protocol})));
        return provider.getServerPorts().stream().filter(Objects::nonNull).map(port -> connectorBuilder.build((int)port, provider)).collect(Collectors.toList());
    }
}

