/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.server.http.FitFilterSupplier;
import com.huawei.fitframework.broker.server.http.FitServletSupplier;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.plugin.http.server.tomcat.config.ConnectorFactory;
import com.huawei.fitframework.plugin.http.server.tomcat.config.TomcatConfigurator;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import com.huawei.fitframework.runtime.SystemDirectories;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.apache.catalina.Context;
import org.apache.catalina.Service;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;

@Fitable
public class DefaultTomcatConfigurator
implements TomcatConfigurator {
    private static final String PLUGIN_HTTP_SERVER = "fit-http-server";
    private static final String DEFAULT_PATH = "";
    private final WebConfigProvider provider;
    private final ConnectorFactory connectorFactory;
    private final BrokerClient brokerClient;

    public DefaultTomcatConfigurator(WebConfigProvider provider, ConnectorFactory connectorFactory, BrokerClient brokerClient) {
        this.provider = provider;
        this.connectorFactory = connectorFactory;
        this.brokerClient = brokerClient;
    }

    @Override
    public void config(Tomcat tomcat) {
        tomcat.setSilent(true);
        tomcat.setHostname(this.provider.getServerHost());
        tomcat.setBaseDir(this.findBaseDir());
        tomcat.getHost().setAutoDeploy(false);
        Service service = tomcat.getService();
        this.connectorFactory.createConnectors(this.provider).forEach(arg_0 -> ((Service)service).addConnector(arg_0));
        Context context = tomcat.addContext(DEFAULT_PATH, null);
        context.setAllowCasualMultipartParsing(true);
        context.setParentClassLoader(this.getClass().getClassLoader());
        this.addServlets(tomcat, context);
        this.addFilters(context);
    }

    private String findBaseDir() {
        return SystemDirectories.allPlugins().stream().filter(plugin -> Objects.equals(plugin.name(), PLUGIN_HTTP_SERVER)).findFirst().map(SystemDirectories.Plugin::root).map(FileUtils::path).orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No plugin with name[{0}].", (Object[])new Object[]{PLUGIN_HTTP_SERVER})));
    }

    private void addServlets(Tomcat tomcat, Context context) {
        this.brokerClient.list(FitServletSupplier.class).values().forEach(servlet -> this.addServlet((FitServletSupplier)servlet, tomcat, context));
    }

    private void addServlet(FitServletSupplier fitServlet, Tomcat tomcat, Context context) {
        tomcat.addServlet(DEFAULT_PATH, fitServlet.name(), fitServlet.servlet());
        context.addServletMappingDecoded(fitServlet.mapping(), fitServlet.name());
    }

    private void addFilters(Context context) {
        this.brokerClient.list(FitFilterSupplier.class).values().stream().sorted(Comparator.comparing(FitFilterSupplier::getOrder)).forEach(supplier -> this.addFilter((FitFilterSupplier)supplier, context));
    }

    private void addFilter(FitFilterSupplier fitFilterSupplier, Context context) {
        context.addFilterDef(this.toFilterDef(fitFilterSupplier));
        context.addFilterMap(this.toFilterMap(fitFilterSupplier));
    }

    private FilterDef toFilterDef(FitFilterSupplier fitFilterSupplier) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilter(fitFilterSupplier.filter());
        filterDef.setFilterClass(fitFilterSupplier.filterClassName());
        filterDef.setFilterName(fitFilterSupplier.filterName());
        Optional.ofNullable(fitFilterSupplier.parameters()).ifPresent(parameters -> parameters.forEach((arg_0, arg_1) -> ((FilterDef)filterDef).addInitParameter(arg_0, arg_1)));
        return filterDef;
    }

    private FilterMap toFilterMap(FitFilterSupplier fitFilterSupplier) {
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(fitFilterSupplier.filterName());
        filterMap.setCharset(fitFilterSupplier.charset());
        Optional.ofNullable(fitFilterSupplier.urlPattern()).ifPresent(urlPattern -> urlPattern.forEach(arg_0 -> ((FilterMap)filterMap).addURLPatternDecoded(arg_0)));
        return filterMap;
    }
}

