/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.plugin.http.server.tomcat.config.SslConfig;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebProtocol;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultWebConfigProvider
implements WebConfigProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultWebConfigProvider.class);
    private final String host;
    private final Set<Integer> ports;
    private final String sslConfigFile;
    private final boolean sslEnable;
    private final int maxPostSize;
    private final Integer acceptCount;
    private final Integer maxThreads;
    private final Integer maxConnections;
    private final String serverAddress;

    public DefaultWebConfigProvider(@Value(value="${server.host}") String host, @Value(value="${server.http.port}") Integer port, @Value(value="${server.http.ports}") List<Integer> ports, @Value(value="${server.http.accept-count}") Integer acceptCount, @Value(value="${server.http.max-threads}") Integer maxThreads, @Value(value="${server.http.max-connections}") Integer maxConnections, @Value(value="${server.http.allowed.max-post-size}") Integer maxPostSize, @Value(value="${server.http.ssl.enable}") Boolean sslEnable, @Value(value="${server.http.ssl.config-file}") String sslConfigFile, @Value(value="${server.http.address}") String serverAddress) {
        this.host = Validation.notBlank((String)host, (String)"No host. [config=server.host]", (Object[])new Object[0]);
        this.sslEnable = Optional.ofNullable(sslEnable).orElse(false);
        this.maxPostSize = (Integer)Validation.notNull((Object)maxPostSize, (String)"No max post size. [config=server.http.allowed.max-post-size]", (Object[])new Object[0]);
        this.ports = new HashSet<Integer>(CollectionUtils.connect((List[])new List[]{Collections.singletonList(port), ports}));
        Validation.isTrue((boolean)CollectionUtils.isNotEmpty(this.ports), (String)"Server ports can not be empty.", (Object[])new Object[0]);
        this.sslConfigFile = sslConfigFile;
        this.acceptCount = acceptCount;
        this.maxConnections = maxConnections;
        this.maxThreads = maxThreads;
        this.serverAddress = serverAddress;
    }

    @Override
    public String getServerHost() {
        return this.host;
    }

    @Override
    public Set<Integer> getServerPorts() {
        return this.ports;
    }

    @Override
    public WebProtocol getProtocol() {
        return this.sslEnable ? WebProtocol.HTTPS : WebProtocol.HTTP;
    }

    @Override
    public int getAllowedMaxPostSize() {
        return this.maxPostSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SslConfig loadSslConfig() {
        try (FileInputStream inputStream = new FileInputStream(this.sslConfigFile);){
            SslConfig config = new SslConfig();
            Properties properties = new Properties();
            properties.load(inputStream);
            Arrays.stream(SslConfig.class.getDeclaredFields()).filter(field -> properties.containsKey(field.getName())).forEach(field -> ReflectionUtils.setField((Object)config, (Field)field, (Object)properties.getProperty(field.getName())));
            SslConfig sslConfig = config;
            return sslConfig;
        }
        catch (IOException e) {
            log.error("Load ssl config failed. [errorMsg={}]", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public String getSslConfigFile() {
        return this.sslConfigFile;
    }

    @Override
    public boolean sslEnable() {
        return this.sslEnable;
    }

    @Override
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public Integer getAcceptCount() {
        return this.acceptCount;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }
}

