/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.crypt.Decrypt;
import com.huawei.fitframework.plugin.http.server.tomcat.config.SslConfig;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebProtocol;
import com.huawei.fitframework.plugin.http.server.tomcat.config.support.AbstractConnectorBuilder;
import java.util.Optional;
import lombok.Generated;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsConnectorBuilder
extends AbstractConnectorBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpsConnectorBuilder.class);
    private static final String PROTOCOL = "org.apache.coyote.http11.Http11NioProtocol";
    private static final String SCHEMA = "https";
    private static final String DEFAULT_DECRYPT_ALIAS = "defaultDecrypt";
    private final BrokerClient brokerClient;

    public HttpsConnectorBuilder(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }

    @Override
    public WebProtocol protocol() {
        return WebProtocol.HTTPS;
    }

    @Override
    protected Connector createConnector() {
        return new Connector(PROTOCOL);
    }

    @Override
    protected void setConnectorProperties(Connector connector, WebConfigProvider provider) {
        connector.setSecure(true);
        connector.setScheme(SCHEMA);
        connector.setProperty("bindOnInit", "false");
        SslConfig sslConfig = provider.loadSslConfig();
        Validation.notNull((Object)sslConfig, (String)"Ssl config can not be null.", (Object[])new Object[0]);
        this.setProtocol((Http11NioProtocol)ObjectUtils.cast((Object)connector.getProtocolHandler()), sslConfig);
    }

    private void setProtocol(Http11NioProtocol protocol, SslConfig sslConfig) {
        protocol.setClientAuth(sslConfig.getClientAuth());
        protocol.setSSLEnabled(true);
        Optional.ofNullable(sslConfig.getSslProtocol()).ifPresent(arg_0 -> ((Http11NioProtocol)protocol).setSSLProtocol(arg_0));
        this.setKeyStore(protocol, sslConfig);
        this.setTruststore(protocol, sslConfig);
    }

    private void setTruststore(Http11NioProtocol protocol, SslConfig sslConfig) {
        Optional.ofNullable(sslConfig.getTruststoreFile()).ifPresent(arg_0 -> ((Http11NioProtocol)protocol).setTruststoreFile(arg_0));
        Optional.ofNullable(sslConfig.getTruststoreType()).ifPresent(arg_0 -> ((Http11NioProtocol)protocol).setTruststoreType(arg_0));
        Optional.ofNullable(sslConfig.getTruststorePass()).ifPresent(pass -> {
            String decryptKey = sslConfig.getTruststorePassDecryptKey();
            String decryptType = sslConfig.getTruststorePassDecryptType();
            protocol.setTruststorePass(this.decrypt((String)pass, decryptKey, decryptType));
        });
    }

    private void setKeyStore(Http11NioProtocol protocol, SslConfig sslConfig) {
        protocol.setKeystoreFile(sslConfig.getKeystoreFile());
        protocol.setKeystoreType(sslConfig.getKeystoreType());
        protocol.setKeystorePass(this.decrypt(sslConfig.getKeystorePass(), sslConfig.getKeystorePassDecryptKey(), sslConfig.getKeystorePassDecryptType()));
        Optional.ofNullable(sslConfig.getKeyAlias()).ifPresent(arg_0 -> ((Http11NioProtocol)protocol).setKeyAlias(arg_0));
    }

    private String decrypt(String pass, String decryptKey, String decryptType) {
        String decryptAlias = Optional.ofNullable(decryptType).orElse(DEFAULT_DECRYPT_ALIAS);
        Decrypt decrypt = (Decrypt)this.brokerClient.getProxyByAlias(Decrypt.class, decryptAlias);
        return decrypt.decrypt(pass, decryptKey);
    }
}

