/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.plugin.http.server.tomcat.config.ConnectorFactory;
import com.huawei.fitframework.plugin.http.server.tomcat.config.FileMonitor;
import com.huawei.fitframework.plugin.http.server.tomcat.config.Monitor;
import com.huawei.fitframework.plugin.http.server.tomcat.config.WebConfigProvider;
import com.huawei.fitframework.plugin.http.server.tomcat.config.support.WatchServiceFileMonitor;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.catalina.Service;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfigMonitor
implements Monitor,
Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SslConfigMonitor.class);
    private static final String ENTRY_DELETE = "ENTRY_DELETE";
    private static final String ENTRY_MODIFY = "ENTRY_MODIFY";
    private static final String ENTRY_CREATE = "ENTRY_CREATE";
    private final Tomcat tomcat;
    private final WebConfigProvider provider;
    private final ConnectorFactory connectorFactory;
    private final FileMonitor fileMonitor;
    private final ExecutorService executor;

    public SslConfigMonitor(Tomcat tomcat, WebConfigProvider provider, ConnectorFactory connectorFactory) {
        this.tomcat = tomcat;
        this.provider = provider;
        this.connectorFactory = connectorFactory;
        this.fileMonitor = new WatchServiceFileMonitor(this.provider.getSslConfigFile());
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void run() {
        log.warn("---------- start https config monitor successful ----------");
        this.fileMonitor.registerObserver(this::updateConnector);
        this.fileMonitor.start();
        log.warn("---------- https config monitor exit gracefully ----------");
    }

    private void updateConnector(File file, String type) {
        switch (type) {
            case "ENTRY_DELETE": {
                this.deleteConnectors();
                break;
            }
            case "ENTRY_CREATE": {
                this.createConnectors();
                break;
            }
            case "ENTRY_MODIFY": {
                this.deleteConnectors();
                this.createConnectors();
            }
        }
    }

    private void createConnectors() {
        Service service = this.tomcat.getService();
        this.connectorFactory.createConnectors(this.provider).forEach(arg_0 -> ((Service)service).addConnector(arg_0));
    }

    private void deleteConnectors() {
        Service service = this.tomcat.getService();
        Stream.of(service.findConnectors()).forEach(arg_0 -> ((Service)service).removeConnector(arg_0));
    }

    @Override
    public void start() {
        this.executor.execute(this);
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
        this.fileMonitor.stop();
    }
}

